/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.core;

import java.util.HashMap;
import java.util.Map;

public class RequestContext {
    private static final ThreadLocal<Map<String, Object>> context = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static final ThreadLocal<Boolean> isImmutable = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static void initialize() {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.remove();
        isImmutable.set(false);
    }

    public static void initialize(Map<String, Object> ctxt) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.remove();
        context.get().putAll(ctxt);
        isImmutable.set(true);
    }

    public static void set(String key, Object value) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.get().put(key, value);
    }

    public static Object get(String key) {
        return context.get().get(key);
    }

    public static Map<String, Object> getContextMap() {
        return new HashMap<String, Object>(context.get());
    }

    public static void shutDown() {
        context.remove();
        isImmutable.remove();
    }
}

