/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.datasources;

import com.flipkart.poseidon.datasources.util.CallableNameHelper;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.DataType;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import java.util.List;

public abstract class AbstractDataSource<T extends DataType>
implements DataSource {
    protected final PoseidonLegoSet legoset;
    protected final Request request;

    public AbstractDataSource(LegoSet legoset, Request request) {
        this.legoset = (PoseidonLegoSet)legoset;
        this.request = request;
    }

    public abstract T call() throws Exception;

    public String getId() throws UnsupportedOperationException {
        return this.getName() + "_" + Joiner.on((String)".").join(this.getVersion());
    }

    public String getName() throws UnsupportedOperationException {
        return CallableNameHelper.canonicalName(this.getClass().getSimpleName(), "DataSource", "DS");
    }

    public List<Integer> getVersion() throws UnsupportedOperationException {
        return Lists.newArrayList((Object[])new Integer[]{1, 0, 0});
    }

    public String getShortDescription() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return this.getClass().getName();
    }
}

