/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.legoset;

import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.flipkart.poseidon.tracing.TraceHelper;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.DataType;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.helpers.Identifiable;
import java.util.List;
import java.util.Map;

public class ContextInducedDataSource
implements DataSource {
    private final DataSource dataSource;
    private final Request request;
    private final Map<String, Object> parentContext;
    private final Map<String, Object> parentServiceContext;
    private final HystrixRequestContext parentThreadState;
    private final ServerSpan serverSpan;

    public ContextInducedDataSource(DataSource dataSource, Request request) {
        this.dataSource = dataSource;
        this.request = request;
        this.parentContext = RequestContext.getContextMap();
        this.parentServiceContext = ServiceContext.getContextMap();
        this.parentThreadState = HystrixRequestContext.getContextForCurrentThread();
        this.serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType call() throws Exception {
        HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
        boolean success = false;
        try {
            RequestContext.initialize(this.parentContext);
            ServiceContext.initialize(this.parentServiceContext);
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)this.parentThreadState);
            if (this.serverSpan != null && this.serverSpan.getSpan() != null) {
                Brave.getServerSpanThreadBinder().setCurrentSpan(this.serverSpan);
            }
            TraceHelper.startTrace((Identifiable)this.dataSource, this.request);
            DataType dataType = (DataType)this.dataSource.call();
            success = true;
            DataType dataType2 = dataType;
            return dataType2;
        }
        finally {
            RequestContext.shutDown();
            ServiceContext.shutDown();
            HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)existingState);
            TraceHelper.endTrace((Identifiable)this.dataSource, success);
            Brave.getServerSpanThreadBinder().setCurrentSpan(null);
        }
    }

    public String getId() throws UnsupportedOperationException {
        return this.dataSource.getId();
    }

    public String getName() throws UnsupportedOperationException {
        return this.dataSource.getName();
    }

    public List<Integer> getVersion() throws UnsupportedOperationException {
        return this.dataSource.getVersion();
    }

    public String getShortDescription() {
        return this.dataSource.getShortDescription();
    }

    public String getDescription() {
        return this.dataSource.getDescription();
    }
}

