/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.tracing;

import com.flipkart.phantom.runtime.impl.spring.ServiceProxyComponentContainer;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.helper.BlocksHelper;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.helpers.Identifiable;
import java.util.Arrays;
import java.util.List;

public class TraceHelper {
    private static final String FAILURE_ANNOTATION = "failure";
    private static final String REQUEST_ANNOTATION = "request";
    private static final List<TraceFilter> TRACING_ON_FILTERS = Arrays.asList(AbstractHandler.TRACING_ON);
    private static final EventDispatchingSpanCollector SPAN_COLLECTOR = TraceHelper.getBean("eventDispatchingSpanCollector", EventDispatchingSpanCollector.class);

    public static <T> T getBean(String beanId, Class<T> tClass) {
        return (T)ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext().getBean(beanId, tClass);
    }

    public static EventDispatchingSpanCollector getSpanCollector() {
        return SPAN_COLLECTOR;
    }

    public static void startTrace(Identifiable block) {
        TraceHelper.startTrace(block, null);
    }

    public static boolean isTracingEnabledRequest() {
        Boolean enableTracing = (Boolean)RequestContext.get("poseidon.enableTracing");
        return enableTracing != null && enableTracing != false;
    }

    public static void startTrace(Identifiable block, Request request) {
        if (!TraceHelper.isTracingEnabledRequest() || !BlocksHelper.trace(block)) {
            return;
        }
        String name = BlocksHelper.getName(block);
        ClientTracer clientTracer = Brave.getClientTracer((SpanCollector)SPAN_COLLECTOR, TRACING_ON_FILTERS);
        clientTracer.startNewSpan(name);
        clientTracer.setCurrentClientServiceName(name);
        if (request != null) {
            clientTracer.submitBinaryAnnotation(REQUEST_ANNOTATION, request.toString());
        }
        clientTracer.setClientSent();
    }

    public static void endTrace(Identifiable block, boolean success) {
        if (!TraceHelper.isTracingEnabledRequest() || !BlocksHelper.trace(block)) {
            return;
        }
        ClientTracer clientTracer = Brave.getClientTracer((SpanCollector)SPAN_COLLECTOR, TRACING_ON_FILTERS);
        if (!success) {
            clientTracer.submitAnnotation(FAILURE_ANNOTATION);
        }
        clientTracer.setClientReceived();
    }
}

