/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.datasources;

import co.paralleluniverse.fibers.Suspendable;
import com.flipkart.poseidon.datasources.DataSourceRequest;
import com.flipkart.poseidon.legoset.PoseidonLegoSet;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.DataType;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import java.util.Map;
import java.util.concurrent.Future;

public abstract class AbstractDataSource<T extends DataType>
implements DataSource<T> {
    protected final PoseidonLegoSet legoset;
    protected final Request request;

    public AbstractDataSource(LegoSet legoset, Request request) {
        this.legoset = (PoseidonLegoSet)legoset;
        this.request = request;
    }

    @Suspendable
    protected <Q extends DataType> Future<Q> execute(String dsId, Map<String, Object> requestMap) throws Exception {
        DataSourceRequest dataSourceRequest = new DataSourceRequest();
        dataSourceRequest.setAttributes(requestMap);
        return this.execute(dsId, dataSourceRequest);
    }

    @Suspendable
    protected <Q extends DataType> Future<Q> execute(AbstractDataSource<Q> dataSource) throws Exception {
        return this.legoset.getDataSourceExecutor().submit(this.legoset.wrapDataSource(dataSource, dataSource.getRequest()));
    }

    @Suspendable
    protected <Q extends DataType> Future<Q> execute(String dsId, Request request) throws Exception {
        DataSource dataSource = this.legoset.getDataSource(dsId, request);
        return this.legoset.getDataSourceExecutor().submit(dataSource);
    }

    @Suspendable
    protected <Q extends DataType> Q executeSync(AbstractDataSource<Q> dataSource) throws Exception {
        return dataSource.call();
    }

    @Suspendable
    public abstract T call() throws Exception;

    protected Request getRequest() {
        return this.request;
    }
}

