/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.core;

import com.google.common.collect.ImmutableMap;
import flipkart.lego.api.entities.Request;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class PoseidonRequest
implements Request {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final String url;
    private final Optional<HttpServletRequest> httpRequest;
    private final ImmutableMap<String, Cookie> cookies;
    private final ImmutableMap<String, String> headers;

    public PoseidonRequest(String url, ImmutableMap<String, Cookie> cookies, ImmutableMap<String, String> headers, Map<String, String[]> attributes) {
        this.url = url;
        this.cookies = cookies;
        this.headers = headers;
        this.httpRequest = Optional.empty();
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public PoseidonRequest(HttpServletRequest httpRequest) {
        this.url = httpRequest.getPathInfo();
        this.headers = this.extractHeaders(httpRequest);
        this.cookies = this.extractCookies(httpRequest);
        this.httpRequest = Optional.of(httpRequest);
        if (httpRequest.getParameterMap() != null) {
            this.attributes.putAll(httpRequest.getParameterMap());
        }
    }

    public Optional<HttpServletRequest> getHttpRequest() {
        return this.httpRequest;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void setAttributes(Map<String, Object> map) {
        if (this.attributes != null) {
            this.attributes.putAll(this.attributes);
        }
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    public Map<String, Object> getAttributeMap() {
        return new HashMap<String, Object>(this.attributes);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    private ImmutableMap<String, String> extractHeaders(HttpServletRequest httpServletRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            if (httpServletRequest.getHeader(key) == null) continue;
            headers.put(key.toLowerCase(), httpServletRequest.getHeader(key));
        }
        return ImmutableMap.copyOf(headers);
    }

    private ImmutableMap<String, Cookie> extractCookies(HttpServletRequest httpServletRequest) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        Cookie[] receivedCookies = httpServletRequest.getCookies();
        if (receivedCookies != null) {
            for (Cookie cookie : receivedCookies) {
                cookies.put(cookie.getName().toLowerCase(), cookie);
            }
        }
        return ImmutableMap.copyOf(cookies);
    }

    public Cookie getCookie(String key) {
        return this.cloneCookie((Cookie)this.cookies.get((Object)key.toLowerCase()));
    }

    public String getHeader(String key) {
        return (String)this.headers.get((Object)key.toLowerCase());
    }

    private Cookie cloneCookie(Cookie cookie) {
        Cookie newCookie = null;
        if (cookie != null) {
            newCookie = new Cookie(cookie.getName(), cookie.getValue());
            newCookie.setSecure(cookie.getSecure());
            newCookie.setMaxAge(cookie.getMaxAge());
            newCookie.setVersion(cookie.getVersion());
            if (cookie.getDomain() != null) {
                newCookie.setDomain(cookie.getDomain());
            }
            if (cookie.getComment() != null) {
                newCookie.setComment(cookie.getComment());
            }
            if (cookie.getPath() != null) {
                newCookie.setPath(cookie.getPath());
            }
        }
        return newCookie;
    }
}

