/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.legoset;

import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.flipkart.poseidon.serviceclients.ServiceDebug;
import com.flipkart.poseidon.tracing.TraceHelper;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import flipkart.lego.api.entities.Block;
import flipkart.lego.api.entities.Request;
import java.util.List;
import java.util.Map;
import org.slf4j.MDC;

public abstract class ContextInducedBlock {
    private final Block block;
    private final Map<String, Object> parentContext;
    private final Map<String, Object> parentServiceContext;
    private final boolean isServiceDebugEnabled;
    private final Map<String, List<ServiceDebug>> debugResponses;
    private final HystrixRequestContext parentThreadState;
    private final Map<String, String> mdcContext;
    private final ServerSpan serverSpan;
    private HystrixRequestContext existingState;
    protected boolean success = false;

    protected ContextInducedBlock(Block block) {
        this.block = block;
        this.parentContext = RequestContext.getContextMap();
        this.parentServiceContext = ServiceContext.getContextMap();
        this.isServiceDebugEnabled = ServiceContext.isDebug();
        this.debugResponses = ServiceContext.getDebugResponses();
        this.parentThreadState = HystrixRequestContext.getContextForCurrentThread();
        this.mdcContext = MDC.getCopyOfContextMap();
        this.serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
    }

    protected void initAllContext(Request request) {
        this.existingState = HystrixRequestContext.getContextForCurrentThread();
        RequestContext.initialize(this.parentContext);
        ServiceContext.initialize(this.parentServiceContext, (boolean)this.isServiceDebugEnabled, this.debugResponses);
        HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)this.parentThreadState);
        if (this.mdcContext != null) {
            MDC.setContextMap(this.mdcContext);
        }
        if (this.serverSpan != null && this.serverSpan.getSpan() != null) {
            Brave.getServerSpanThreadBinder().setCurrentSpan(this.serverSpan);
        }
        TraceHelper.startTrace(this.block, request);
    }

    protected void shutdownAllContext() {
        TraceHelper.endTrace(this.block, this.success);
        RequestContext.shutDown();
        ServiceContext.shutDown();
        HystrixRequestContext.setContextOnCurrentThread((HystrixRequestContext)this.existingState);
        MDC.clear();
        Brave.getServerSpanThreadBinder().setCurrentSpan(null);
    }
}

