/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.legoset;

import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.datasources.RequestAttribute;
import com.flipkart.poseidon.datasources.ServiceClient;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import com.flipkart.poseidon.helper.AnnotationHelper;
import com.flipkart.poseidon.helper.CallableNameHelper;
import com.flipkart.poseidon.helper.ClassPathHelper;
import com.flipkart.poseidon.legoset.ContextInducedDataSource;
import com.flipkart.poseidon.legoset.ContextInducedFilter;
import com.flipkart.poseidon.mappers.Mapper;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.model.exception.MissingInformationException;
import com.flipkart.poseidon.model.exception.PoseidonFailureException;
import com.google.common.reflect.ClassPath;
import flipkart.lego.api.entities.Buildable;
import flipkart.lego.api.entities.DataSource;
import flipkart.lego.api.entities.DataType;
import flipkart.lego.api.entities.Filter;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.exceptions.ElementNotFoundException;
import flipkart.lego.api.exceptions.LegoSetException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public abstract class PoseidonLegoSet
implements LegoSet {
    private static final Logger logger = LoggerFactory.getLogger(PoseidonLegoSet.class);
    private static Map<String, Constructor<DataSource<? extends DataType>>> dataSources = new HashMap<String, Constructor<DataSource<? extends DataType>>>();
    private static Map<String, flipkart.lego.api.entities.ServiceClient> serviceClients = new HashMap<String, flipkart.lego.api.entities.ServiceClient>();
    private static Map<String, flipkart.lego.api.entities.ServiceClient> serviceClientsByName = new HashMap<String, flipkart.lego.api.entities.ServiceClient>();
    private static Map<String, Filter> filters = new HashMap<String, Filter>();
    private static Map<String, Mapper> mappers = new HashMap<String, Mapper>();
    private Map<String, Buildable> buildableMap = new HashMap<String, Buildable>();
    private ExecutorService dataSourceExecutor;
    private ApplicationContext context;

    public void init() {
        try {
            Set<ClassPath.ClassInfo> classInfos = ClassPathHelper.getPackageClasses(ClassLoader.getSystemClassLoader(), this.getPackagesToScan());
            ArrayList<Class<flipkart.lego.api.entities.ServiceClient>> serviceClientClasses = new ArrayList<Class<flipkart.lego.api.entities.ServiceClient>>();
            ArrayList<Class<Filter>> filterClasses = new ArrayList<Class<Filter>>();
            for (ClassPath.ClassInfo classInfo : classInfos) {
                this.bucketize(classInfo, serviceClientClasses, filterClasses);
            }
            for (Class clazz : serviceClientClasses) {
                this.processServiceClient(clazz);
            }
            for (Class clazz : filterClasses) {
                this.processFilter(clazz);
            }
        }
        catch (MissingInformationException | ElementNotFoundException | IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Unable to load lego-blocks into their containers", e);
            throw new PoseidonFailureException("Unable to load lego-blocks into their containers", e);
        }
    }

    private void bucketize(ClassPath.ClassInfo aClass, List<Class<flipkart.lego.api.entities.ServiceClient>> serviceClientClasses, List<Class<Filter>> filterClasses) {
        try {
            Class<DataSource<? extends DataType>> klass = Class.forName(aClass.getName());
            if (!this.isAbstract(klass)) {
                if (DataSource.class.isAssignableFrom(klass)) {
                    this.processDataSource(klass);
                } else if (flipkart.lego.api.entities.ServiceClient.class.isAssignableFrom(klass)) {
                    serviceClientClasses.add(klass);
                } else if (Filter.class.isAssignableFrom(klass)) {
                    filterClasses.add(klass);
                } else if (Mapper.class.isAssignableFrom(klass)) {
                    Mapper mapper = (Mapper)klass.newInstance();
                    mappers.put(PoseidonLegoSet.getBlockId(klass).orElseThrow(MissingInformationException::new), mapper);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Unable to instantiate " + aClass.getName(), t);
            throw new PoseidonFailureException("Unable to instantiate " + aClass.getName(), t);
        }
    }

    private void processDataSource(Class<DataSource<? extends DataType>> klass) throws NoSuchMethodException, MissingInformationException {
        Constructor<DataSource<? extends DataType>> constructor;
        List<Constructor<DataSource<? extends DataType>>> injectableConstructors = this.findInjectableConstructors(klass);
        if (injectableConstructors.isEmpty()) {
            constructor = klass.getDeclaredConstructor(LegoSet.class, Request.class);
        } else {
            constructor = injectableConstructors.get(0);
            if (constructor.getParameterCount() < 2 || constructor.getParameterTypes()[0] != LegoSet.class || constructor.getParameterTypes()[1] != Request.class) {
                throw new UnsupportedOperationException("The injectable constructor of " + klass.getName() + " must have LegoSet and Request as the first two parameter");
            }
        }
        Optional<String> id = PoseidonLegoSet.getBlockId(klass);
        if (!id.isPresent()) {
            throw new MissingInformationException();
        }
        dataSources.put(id.get(), constructor);
    }

    private void processServiceClient(Class<flipkart.lego.api.entities.ServiceClient> klass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, MissingInformationException, ElementNotFoundException {
        flipkart.lego.api.entities.ServiceClient serviceClient;
        List<Constructor<flipkart.lego.api.entities.ServiceClient>> injectableConstructors = this.findInjectableConstructors(klass);
        if (injectableConstructors.isEmpty()) {
            Constructor<flipkart.lego.api.entities.ServiceClient> constructor = klass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            serviceClient = constructor.newInstance(new Object[0]);
        } else {
            serviceClient = (flipkart.lego.api.entities.ServiceClient)this.context.getAutowireCapableBeanFactory().createBean(klass);
        }
        serviceClients.put(PoseidonLegoSet.getBlockId(klass).orElseThrow(MissingInformationException::new), serviceClient);
        for (Class<?> interfaceClass : klass.getInterfaces()) {
            if (!flipkart.lego.api.entities.ServiceClient.class.isAssignableFrom(interfaceClass)) continue;
            serviceClientsByName.put(interfaceClass.getName(), serviceClient);
        }
        serviceClientsByName.put(klass.getName(), serviceClient);
    }

    private void processFilter(Class<Filter> klass) throws IllegalAccessException, InvocationTargetException, InstantiationException, MissingInformationException, ElementNotFoundException {
        Filter filter;
        try {
            List<Constructor<Filter>> injectableConstructors = this.findInjectableConstructors(klass);
            if (injectableConstructors.isEmpty()) {
                Constructor<Filter> constructor = klass.getDeclaredConstructor(LegoSet.class);
                filter = constructor.newInstance(this);
            } else {
                Constructor<Filter> constructor = injectableConstructors.get(0);
                if (constructor.getParameterCount() < 1 || constructor.getParameterTypes()[0] != LegoSet.class) {
                    throw new UnsupportedOperationException("The injectable constructor of " + klass.getName() + " must have LegoSet as the first parameter");
                }
                Object[] initParams = new Object[constructor.getParameterCount()];
                initParams[0] = this;
                this.resolveInjectableConstructorDependencies(constructor, initParams, 1, Optional.empty());
                filter = constructor.newInstance(initParams);
            }
        }
        catch (NoSuchMethodException e) {
            filter = klass.newInstance();
        }
        filters.put(PoseidonLegoSet.getBlockId(klass).orElseThrow(MissingInformationException::new), filter);
    }

    private <T> List<Constructor<T>> findInjectableConstructors(Class<T> klass) {
        Constructor<?>[] declaredConstructors = klass.getDeclaredConstructors();
        List<Constructor<T>> injectableConstructors = Arrays.stream(declaredConstructors).filter(c -> c.isAnnotationPresent(Inject.class)).collect(Collectors.toList());
        if (injectableConstructors.size() > 1) {
            throw new UnsupportedOperationException(klass.getName() + " has more than one injectable constructor");
        }
        return injectableConstructors;
    }

    public static Optional<String> getBlockId(Class<?> klass) {
        Optional<String> optionalName = Optional.ofNullable(klass.getDeclaredAnnotation(Name.class)).map(Name::value);
        Optional<String> optionalVersion = Optional.ofNullable(klass.getDeclaredAnnotation(Version.class)).map(AnnotationHelper::constructVersion);
        String id = CallableNameHelper.versionedName((String)optionalName.orElse(klass.getSimpleName()), (String)optionalVersion.orElse(""));
        return optionalVersion.isPresent() ? Optional.of(id) : Optional.empty();
    }

    private boolean isAbstract(Class klass) {
        return Modifier.isAbstract(klass.getModifiers());
    }

    public <T extends DataType> DataSource<T> getDataSource(String id, Request request) throws LegoSetException, ElementNotFoundException {
        DataSource<T> dataSource = this.getBasicDataSource(id, request);
        return this.wrapDataSource(dataSource, request);
    }

    public <T extends DataType> DataSource<T> getBasicDataSource(String id, Request request) throws LegoSetException, ElementNotFoundException {
        if (!dataSources.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find DataSource for provided id = " + id);
        }
        try {
            DataSource<? extends DataType> dataSource;
            Constructor<DataSource<? extends DataType>> dataSourceConstructor = dataSources.get(id);
            if (dataSourceConstructor.getParameterCount() == 2) {
                dataSource = dataSourceConstructor.newInstance(this, request);
            } else {
                Object[] initParams = new Object[dataSourceConstructor.getParameterCount()];
                initParams[0] = this;
                initParams[1] = request;
                this.resolveInjectableConstructorDependencies(dataSourceConstructor, initParams, 2, Optional.ofNullable(request));
                dataSource = dataSourceConstructor.newInstance(initParams);
            }
            return dataSource;
        }
        catch (Exception e) {
            throw new LegoSetException("Unable to instantiate DataSource for provided id = " + id, (Throwable)e);
        }
    }

    public boolean doesDataSourceExist(String dsId) {
        return dataSources.get(dsId) != null;
    }

    public <T extends DataType> DataSource<T> wrapDataSource(DataSource<T> dataSource, Request request) {
        return new ContextInducedDataSource<T>(dataSource, request);
    }

    public flipkart.lego.api.entities.ServiceClient getServiceClient(String id) throws ElementNotFoundException {
        if (!serviceClients.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find ServiceClient for provided id = " + id);
        }
        return serviceClients.get(id);
    }

    public Filter getFilter(String id) throws ElementNotFoundException {
        if (!filters.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find Filter for provided id = " + id);
        }
        return this.wrapFilter(filters.get(id));
    }

    public Filter wrapFilter(Filter filter) {
        return new ContextInducedFilter(filter);
    }

    public Mapper getMapper(String id) throws ElementNotFoundException {
        if (!mappers.containsKey(id)) {
            throw new ElementNotFoundException("Unable to find Mapper for provided id = " + id);
        }
        return mappers.get(id);
    }

    public abstract List<String> getPackagesToScan();

    public Buildable getBuildable(Request request) throws LegoSetException, ElementNotFoundException {
        PoseidonRequest poseidonRequest = (PoseidonRequest)request;
        Buildable buildable = this.buildableMap.get(poseidonRequest.getUrl());
        if (buildable == null) {
            throw new ElementNotFoundException("Buildable not found for given url: " + poseidonRequest.getUrl());
        }
        return buildable;
    }

    public void updateBuildables(Map<String, Buildable> buildableMap) {
        this.buildableMap = buildableMap;
    }

    public void setDataSourceExecutor(ExecutorService dataSourceExecutor) {
        this.dataSourceExecutor = dataSourceExecutor;
    }

    public ExecutorService getDataSourceExecutor() {
        return this.dataSourceExecutor;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    private void resolveInjectableConstructorDependencies(Constructor<?> constructor, Object[] initParams, int offset, Optional<Request> request) throws MissingInformationException, ElementNotFoundException {
        for (int i = offset; i < constructor.getParameterCount(); ++i) {
            RequestAttribute requestAttribute = constructor.getParameters()[i].getAnnotation(RequestAttribute.class);
            ServiceClient serviceClientAttribute = constructor.getParameters()[i].getAnnotation(ServiceClient.class);
            if (requestAttribute != null) {
                String attributeName = StringUtils.isNullOrEmpty((String)requestAttribute.value()) ? constructor.getParameters()[i].getName() : requestAttribute.value();
                initParams[i] = request.map(r -> r.getAttribute(attributeName)).orElse(null);
                continue;
            }
            if (serviceClientAttribute != null) {
                flipkart.lego.api.entities.ServiceClient serviceClient = serviceClientsByName.get(constructor.getParameterTypes()[i].getName());
                if (serviceClient == null) {
                    throw new ElementNotFoundException("Unable to find ServiceClient for class = " + constructor.getParameterTypes()[i]);
                }
                initParams[i] = serviceClient;
                continue;
            }
            Qualifier qualifier = constructor.getParameters()[i].getAnnotation(Qualifier.class);
            String beanName = null;
            if (qualifier != null && !StringUtils.isNullOrEmpty((String)qualifier.value())) {
                beanName = qualifier.value();
            }
            Object object = initParams[i] = beanName == null ? this.context.getBean(constructor.getParameterTypes()[i]) : this.context.getBean(beanName, constructor.getParameterTypes()[i]);
            if (initParams[i] != null) continue;
            throw new MissingInformationException("Unmet dependency for constructor " + constructor.getName() + ": " + constructor.getParameterTypes()[i].getCanonicalName());
        }
    }
}

