/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.handlers.http;

import java.util.Map;
import javax.validation.constraints.NotNull;

public class HttpResponseData {
    private final int statusCode;
    private final byte[] responseBody;
    private final Map<String, String> responseHeaders;

    public HttpResponseData(@NotNull int responseCode, byte[] responseBody, Map<String, String> responseHeaders) {
        this.statusCode = responseCode;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.statusCode).append("\n");
        if (this.responseHeaders != null) {
            for (String key : this.responseHeaders.keySet()) {
                sb.append(key).append(":").append(this.responseHeaders.get(key));
            }
        }
        sb.append("\n\n").append(this.responseBody);
        return sb.toString();
    }
}

