/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.handlers.http.impl.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.poseidon.handlers.http.HttpResponseData;
import com.flipkart.poseidon.handlers.http.impl.SinglePoolHttpTaskHandler;
import com.flipkart.poseidon.handlers.http.impl.oauth.OAuthTokenResponse;
import com.flipkart.poseidon.handlers.http.utils.StringUtils;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class OAuthTokenGenerator
extends SinglePoolHttpTaskHandler {
    private static final Logger logger = LogFactory.getLogger(OAuthTokenGenerator.class);
    private Thread thread;
    private String clientId;
    private String secret;
    private String accessToken;
    private String uri;
    private String authUriPath;
    private String authMethod;
    private Map<String, String> authParams;
    private long expiryTime;
    private boolean stopThread = false;
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void init(TaskContext taskContext) throws Exception {
        this.validate();
        super.init(taskContext);
        this.uri = this.uriBuilder(this.authUriPath, this.authParams);
        if (!this.generateAccessToken()) {
            logger.error("failed to get access token at Init step");
            throw new Exception("failed to get access token at OAuthTokenGenerator Init");
        }
        this.refreshAccessToken();
    }

    private void validate() throws Exception {
        if (StringUtils.isNullOrEmpty(this.clientId) || StringUtils.isNullOrEmpty(this.secret)) {
            throw new Exception("clientId or secret cannot be null");
        }
    }

    private boolean generateAccessToken() {
        OAuthTokenResponse tokenResponse;
        HttpResponseData responseData;
        try {
            responseData = this.makeRequest(this.authMethod, this.uri, null, this.getRequestHeaders());
        }
        catch (Exception e) {
            logger.error("unable to make request to Oauth end point");
            return false;
        }
        if (responseData.getStatusCode() != 200) {
            logger.error("failed to get access token from OAuth endpoint. error: {}", (Object)new String(responseData.getResponseBody()));
            return false;
        }
        try {
            tokenResponse = (OAuthTokenResponse)objectMapper.readValue(new String(responseData.getResponseBody()), OAuthTokenResponse.class);
        }
        catch (Exception e) {
            logger.error("unable to cast response from Oauth to OAuthTokenResponse");
            return false;
        }
        this.accessToken = tokenResponse.getAccessToken();
        this.expiryTime = tokenResponse.getExpiresIn() * 900;
        return true;
    }

    private void refreshAccessToken() {
        TokenRefresher tokenRefresher = new TokenRefresher();
        this.thread = new Thread(tokenRefresher);
        this.thread.start();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    private String uriBuilder(String path, Map<String, String> params) {
        URIBuilder builder = new URIBuilder();
        builder.setPath(path);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.addParameter(entry.getKey(), entry.getValue());
        }
        return builder.toString();
    }

    private Map<String, String> getRequestHeaders() {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String credentials = this.clientId + ":" + this.secret;
        String encodedCredentials = Base64.getEncoder().encodeToString(credentials.getBytes());
        requestHeaders.put("Authorization", "Basic " + encodedCredentials);
        return requestHeaders;
    }

    @Override
    public void shutdown(TaskContext taskContext) throws Exception {
        this.stopThread = true;
        this.thread.join();
        super.shutdown(taskContext);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAuthUriPath(String authUriPath) {
        this.authUriPath = authUriPath;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    private class TokenRefresher
    implements Runnable {
        private TokenRefresher() {
        }

        @Override
        public void run() {
            this.refreshAccessToken();
        }

        private void refreshAccessToken() {
            try {
                while (!OAuthTokenGenerator.this.stopThread) {
                    Thread.sleep(OAuthTokenGenerator.this.expiryTime);
                    while (!OAuthTokenGenerator.this.stopThread && !OAuthTokenGenerator.this.generateAccessToken()) {
                        logger.error("failed to refresh access token. sleeping for 5 seconds");
                        Thread.sleep(5000L);
                    }
                }
            }
            catch (Exception exception) {
                logger.error("error occurred while fetching Oauth access token.");
            }
        }
    }
}

