/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.handlers.http.impl;

import co.paralleluniverse.fibers.httpasyncclient.FiberCloseableHttpAsyncClient;
import com.flipkart.poseidon.handlers.http.HttpDelete;
import com.flipkart.poseidon.handlers.http.impl.DummyFutureCallback;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class HttpConnectionPool {
    private static final Integer defaultMaxConnections = 120;
    private static final Integer defaultProcessQueueSize = 100;
    private static final Integer defaultConnectionTimeout = 0;
    private static final Integer defaultOperationTimeout = 0;
    private static final Boolean defaultSecure = false;
    private static final Integer defaultPort = 80;
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String COMPRESSION_TYPE = "gzip";
    private static final String TIMESTAMP_HEADER = "X-Timestamp";
    private int timeToLiveInSecs = -1;
    private static final Logger logger = LogFactory.getLogger(HttpConnectionPool.class);
    private String name;
    private CloseableHttpAsyncClient client;
    private String host;
    private Integer port;
    private Boolean secure;
    private Map<String, String> headers;
    private Semaphore processQueue;
    private boolean requestGzipEnabled;
    private boolean responseGzipEnabled;
    private PoolingNHttpClientConnectionManager connectionManager;
    private DummyFutureCallback futureCallback;
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("reactor-%d").setUncaughtExceptionHandler((t, e) -> logger.error("Uncaught exception in thread {} - {}", (Object)t.getName(), (Object)e.getMessage())).build();

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected HttpConnectionPool(String name, String host, Integer port, Boolean secure, Integer connectionTimeout, Integer operationTimeout, Integer maxConnections, Integer processQueueSize, Integer timeToLiveInSecs) throws Exception {
        this.name = name;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.headers = new HashMap<String, String>();
        this.processQueue = new Semaphore(processQueueSize + maxConnections);
        if (timeToLiveInSecs != null) {
            this.timeToLiveInSecs = timeToLiveInSecs;
        }
        this.requestGzipEnabled = false;
        this.responseGzipEnabled = false;
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (this.secure.booleanValue()) {
            registryBuilder.register("https", (Object)SSLIOSessionStrategy.getDefaultStrategy());
        } else {
            registryBuilder.register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        }
        IOReactorConfig reactorConfig = IOReactorConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setSoTimeout(operationTimeout.intValue()).setIoThreadCount(1).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(reactorConfig);
        this.connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, null, registryBuilder.build(), null, null, (long)timeToLiveInSecs.intValue(), TimeUnit.SECONDS);
        this.connectionManager.setMaxTotal(maxConnections.intValue());
        this.connectionManager.setDefaultMaxPerRoute(maxConnections.intValue());
        this.connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(host, port.intValue())), maxConnections.intValue());
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClientBuilder.create().disableCookieManagement().setThreadFactory(threadFactory).setConnectionManager((NHttpClientConnectionManager)this.connectionManager);
        httpAsyncClientBuilder.addInterceptorLast((httpRequest, httpContext) -> {
            if (this.isResponseGzipEnabled() && !httpRequest.containsHeader(ACCEPT_ENCODING)) {
                httpRequest.addHeader(ACCEPT_ENCODING, COMPRESSION_TYPE);
            }
        });
        this.futureCallback = new DummyFutureCallback();
        this.client = FiberCloseableHttpAsyncClient.wrap((CloseableHttpAsyncClient)httpAsyncClientBuilder.build());
        this.client.start();
    }

    public static HttpConnectionPool build(Map<String, String> params) throws Exception {
        String host = params.get("host");
        if (host == null) {
            throw new Exception("host not specified");
        }
        String name = params.get("name");
        Integer port = params.get("port") != null ? Integer.parseInt(params.get("port")) : defaultPort;
        Integer connectionTimeout = params.get("connectionTimeout") != null ? Integer.parseInt(params.get("connectionTimeout")) : defaultConnectionTimeout;
        Integer operationTimeout = params.get("operationTimeout") != null ? Integer.parseInt(params.get("operationTimeout")) : defaultOperationTimeout;
        Integer maxConnections = params.get("maxConnections") != null ? Integer.parseInt(params.get("maxConnections")) : defaultMaxConnections;
        Integer timeToLiveInSecs = params.get("timeToLiveInSecs") != null ? Integer.parseInt(params.get("timeToLiveInSecs")) : -1;
        Boolean secure = params.get("secure") != null ? Boolean.parseBoolean(params.get("secure")) : defaultSecure;
        Integer processQueueSize = defaultProcessQueueSize;
        try {
            processQueueSize = Integer.parseInt(params.get("processQueueSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new HttpConnectionPool(name, host, port, secure, connectionTimeout, operationTimeout, maxConnections, processQueueSize, timeToLiveInSecs);
    }

    public HttpResponse doGET(String uri, Map<String, String> requestHeaders) throws Exception {
        HttpGet request = new HttpGet(this.constructUrl(uri));
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doPUT(String uri, byte[] data, Map<String, String> requestHeaders) throws Exception {
        HttpPut request = new HttpPut(this.constructUrl(uri));
        if (data != null) {
            if (this.requestGzipEnabled) {
                request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data)));
            } else {
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
        }
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doPOST(String uri, byte[] data, Map<String, String> requestHeaders) throws Exception {
        HttpPost request = new HttpPost(this.constructUrl(uri));
        if (data != null) {
            if (this.requestGzipEnabled) {
                request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data)));
            } else {
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
        }
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doPOST(String uri, List<NameValuePair> formParams, Map<String, String> requestHeaders) throws Exception {
        HttpPost request = new HttpPost(this.constructUrl(uri));
        if (this.requestGzipEnabled) {
            request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
            request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new UrlEncodedFormEntity(formParams)));
        } else {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        }
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doDELETE(String uri, Map<String, String> requestHeaders) throws Exception {
        HttpDelete request = new HttpDelete(this.constructUrl(uri));
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse execute(HttpRequestBase request) throws Exception {
        if (this.processQueue.tryAcquire()) {
            HttpResponse response;
            try {
                if (request.getHeaders(TIMESTAMP_HEADER).length == 0) {
                    request.addHeader(TIMESTAMP_HEADER, String.valueOf(System.currentTimeMillis()));
                }
                response = (HttpResponse)this.client.execute((HttpUriRequest)request, (FutureCallback)this.futureCallback).get();
                if (this.isResponseGzipEnabled() && response != null && response.getEntity() != null) {
                    response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                }
            }
            catch (Exception e) {
                logger.error("{}. Permits: {}. Exception: {}", new Object[]{this.connectionManager.getTotalStats(), this.processQueue.availablePermits(), e.getMessage()});
                throw e;
            }
            finally {
                this.processQueue.release();
            }
            return response;
        }
        throw new Exception("PROCESS_QUEUE_FULL POOL:" + this.name);
    }

    private void setRequestHeaders(HttpRequestBase request, Map<String, String> headers) {
        Map<String, String> requestHeaders = this.getRequestHeaders(headers);
        for (String key : requestHeaders.keySet()) {
            request.addHeader(key, requestHeaders.get(key));
        }
    }

    private Map<String, String> getRequestHeaders(Map<String, String> headers) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.putAll(this.headers);
        if (headers != null) {
            requestHeaders.putAll(headers);
        }
        return requestHeaders;
    }

    private String constructUrl(String uri) {
        if (this.port == 80) {
            return "http" + (this.secure != false ? "s" : "") + "://" + this.host + uri;
        }
        return "http" + (this.secure != false ? "s" : "") + "://" + this.host + ":" + this.port + uri;
    }

    public HttpRequestBase createHttpRequest(String uri, byte[] data, Map<String, String> requestHeaders, String requestType) {
        if ("GET".equals(requestType)) {
            HttpGet request = new HttpGet(this.constructUrl(uri));
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("POST".equals(requestType)) {
            HttpPost request = new HttpPost(this.constructUrl(uri));
            this.setRequestBody((HttpEntityEnclosingRequestBase)request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("PUT".equals(requestType)) {
            HttpPut request = new HttpPut(this.constructUrl(uri));
            this.setRequestBody((HttpEntityEnclosingRequestBase)request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("DELETE".equals(requestType)) {
            HttpDelete request = new HttpDelete(this.constructUrl(uri));
            this.setRequestBody(request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("PATCH".equals(requestType)) {
            HttpPatch request = new HttpPatch(this.constructUrl(uri));
            this.setRequestBody((HttpEntityEnclosingRequestBase)request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        HttpRequestBase request = null;
        logger.error("Invalid requestType+:" + requestType);
        return request;
    }

    private void setRequestBody(HttpEntityEnclosingRequestBase request, byte[] data) {
        if (data != null) {
            if (this.requestGzipEnabled) {
                request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data)));
            } else {
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
        }
    }

    public boolean isRequestGzipEnabled() {
        return this.requestGzipEnabled;
    }

    public void setRequestGzipEnabled(boolean requestGzipEnabled) {
        this.requestGzipEnabled = requestGzipEnabled;
    }

    public boolean isResponseGzipEnabled() {
        return this.responseGzipEnabled;
    }

    public void setResponseGzipEnabled(boolean responseGzipEnabled) {
        this.responseGzipEnabled = responseGzipEnabled;
    }
}

