/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.handlers.http.impl;

import com.flipkart.poseidon.handlers.http.HttpDelete;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class HttpConnectionPool {
    private static final Integer defaultMaxConnections = 120;
    private static final Integer defaultProcessQueueSize = 100;
    private static final Integer defaultConnectionTimeout = 0;
    private static final Integer defaultOperationTimeout = 0;
    private static final Boolean defaultSecure = false;
    private static final Integer defaultPort = 80;
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String COMPRESSION_TYPE = "gzip";
    private static final String TIMESTAMP_HEADER = "X-Timestamp";
    private int timeToLiveInSecs = -1;
    private static final Logger logger = LogFactory.getLogger(HttpConnectionPool.class);
    private String name;
    private HttpClient client;
    private String host;
    private Integer port;
    private Boolean secure;
    private Map<String, String> headers;
    private Semaphore processQueue;
    private boolean requestGzipEnabled;
    private boolean responseGzipEnabled;

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected HttpConnectionPool(String name, String host, Integer port, Boolean secure, Integer connectionTimeout, Integer operationTimeout, Integer maxConnections, Integer processQueueSize, Integer timeToLiveInSecs) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.headers = new HashMap<String, String>();
        this.processQueue = new Semaphore(processQueueSize + maxConnections);
        if (timeToLiveInSecs != null) {
            this.timeToLiveInSecs = timeToLiveInSecs;
        }
        this.requestGzipEnabled = false;
        this.responseGzipEnabled = false;
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        if (this.secure.booleanValue()) {
            schemeRegistry.register(new Scheme("https", port.intValue(), (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        } else {
            schemeRegistry.register(new Scheme("http", port.intValue(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        }
        PoolingClientConnectionManager cm = this.timeToLiveInSecs > 0 ? new PoolingClientConnectionManager(schemeRegistry, (long)this.timeToLiveInSecs, TimeUnit.SECONDS) : new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(maxConnections.intValue());
        cm.setDefaultMaxPerRoute(maxConnections.intValue());
        HttpHost httpHost = new HttpHost(host, port.intValue());
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxConnections.intValue());
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)operationTimeout);
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        this.client.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        this.addGzipHeaderInRequestResponse();
    }

    public static HttpConnectionPool build(Map<String, String> params) throws Exception {
        String host = params.get("host");
        if (host == null) {
            throw new Exception("host not specified");
        }
        String name = params.get("name");
        Integer port = params.get("port") != null ? Integer.parseInt(params.get("port")) : defaultPort;
        Integer connectionTimeout = params.get("connectionTimeout") != null ? Integer.parseInt(params.get("connectionTimeout")) : defaultConnectionTimeout;
        Integer operationTimeout = params.get("operationTimeout") != null ? Integer.parseInt(params.get("operationTimeout")) : defaultOperationTimeout;
        Integer maxConnections = params.get("maxConnections") != null ? Integer.parseInt(params.get("maxConnections")) : defaultMaxConnections;
        Integer timeToLiveInSecs = params.get("timeToLiveInSecs") != null ? Integer.parseInt(params.get("timeToLiveInSecs")) : -1;
        Boolean secure = params.get("secure") != null ? Boolean.parseBoolean(params.get("secure")) : defaultSecure;
        Integer processQueueSize = defaultProcessQueueSize;
        try {
            processQueueSize = Integer.parseInt(params.get("processQueueSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new HttpConnectionPool(name, host, port, secure, connectionTimeout, operationTimeout, maxConnections, processQueueSize, timeToLiveInSecs);
    }

    public String getStats() {
        PoolingClientConnectionManager cm = (PoolingClientConnectionManager)this.client.getConnectionManager();
        PoolStats stats = cm.getTotalStats();
        return "Connections: " + stats.toString() + " AvailableRequests: " + this.processQueue.availablePermits();
    }

    public HttpResponse doGET(String uri, Map<String, String> requestHeaders) throws Exception {
        HttpGet request = new HttpGet(this.constructUrl(uri));
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doPUT(String uri, byte[] data, Map<String, String> requestHeaders) throws Exception {
        HttpPut request = new HttpPut(this.constructUrl(uri));
        if (data != null) {
            if (this.requestGzipEnabled) {
                request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data)));
            } else {
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
        }
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doPOST(String uri, byte[] data, Map<String, String> requestHeaders) throws Exception {
        HttpPost request = new HttpPost(this.constructUrl(uri));
        if (data != null) {
            if (this.requestGzipEnabled) {
                request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data)));
            } else {
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
        }
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doPOST(String uri, List<NameValuePair> formParams, Map<String, String> requestHeaders) throws Exception {
        HttpPost request = new HttpPost(this.constructUrl(uri));
        if (this.requestGzipEnabled) {
            request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
            request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new UrlEncodedFormEntity(formParams)));
        } else {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        }
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse doDELETE(String uri, Map<String, String> requestHeaders) throws Exception {
        HttpDelete request = new HttpDelete(this.constructUrl(uri));
        this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
        return this.execute((HttpRequestBase)request);
    }

    public HttpResponse execute(HttpRequestBase request) throws Exception {
        if (this.processQueue.tryAcquire()) {
            HttpResponse response;
            try {
                if (request.getHeaders(TIMESTAMP_HEADER).length == 0) {
                    request.addHeader(TIMESTAMP_HEADER, String.valueOf(System.currentTimeMillis()));
                }
                response = this.client.execute((HttpUriRequest)request);
            }
            catch (Exception e) {
                logger.error("Connections: {} AvailableRequests: {}", (Object)((PoolingClientConnectionManager)this.client.getConnectionManager()).getTotalStats(), (Object)this.processQueue.availablePermits());
                throw e;
            }
            finally {
                this.processQueue.release();
            }
            return response;
        }
        throw new Exception("PROCESS_QUEUE_FULL POOL:" + this.name);
    }

    private void setRequestHeaders(HttpRequestBase request, Map<String, String> headers) {
        Map<String, String> requestHeaders = this.getRequestHeaders(headers);
        for (String key : requestHeaders.keySet()) {
            request.addHeader(key, requestHeaders.get(key));
        }
    }

    private Map<String, String> getRequestHeaders(Map<String, String> headers) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.putAll(this.headers);
        if (headers != null) {
            requestHeaders.putAll(headers);
        }
        return requestHeaders;
    }

    private String constructUrl(String uri) {
        if (this.port == 80) {
            return "http" + (this.secure != false ? "s" : "") + "://" + this.host + uri;
        }
        return "http" + (this.secure != false ? "s" : "") + "://" + this.host + ":" + this.port + uri;
    }

    public HttpRequestBase createHttpRequest(String uri, byte[] data, Map<String, String> requestHeaders, String requestType) {
        if ("GET".equals(requestType)) {
            HttpGet request = new HttpGet(this.constructUrl(uri));
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("POST".equals(requestType)) {
            HttpPost request = new HttpPost(this.constructUrl(uri));
            this.setRequestBody((HttpEntityEnclosingRequestBase)request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("PUT".equals(requestType)) {
            HttpPut request = new HttpPut(this.constructUrl(uri));
            this.setRequestBody((HttpEntityEnclosingRequestBase)request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("DELETE".equals(requestType)) {
            HttpDelete request = new HttpDelete(this.constructUrl(uri));
            this.setRequestBody(request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        if ("PATCH".equals(requestType)) {
            HttpPatch request = new HttpPatch(this.constructUrl(uri));
            this.setRequestBody((HttpEntityEnclosingRequestBase)request, data);
            this.setRequestHeaders((HttpRequestBase)request, requestHeaders);
            return request;
        }
        HttpRequestBase request = null;
        logger.error("Invalid requestType+:" + requestType);
        return request;
    }

    private void setRequestBody(HttpEntityEnclosingRequestBase request, byte[] data) {
        if (data != null) {
            if (this.requestGzipEnabled) {
                request.addHeader(CONTENT_ENCODING, COMPRESSION_TYPE);
                request.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(data)));
            } else {
                request.setEntity((HttpEntity)new ByteArrayEntity(data));
            }
        }
    }

    private void addGzipHeaderInRequestResponse() {
        DefaultHttpClient httpclient = (DefaultHttpClient)this.client;
        httpclient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (HttpConnectionPool.this.isResponseGzipEnabled() && !request.containsHeader(HttpConnectionPool.ACCEPT_ENCODING)) {
                    request.addHeader(HttpConnectionPool.ACCEPT_ENCODING, HttpConnectionPool.COMPRESSION_TYPE);
                }
            }
        });
        httpclient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header ceheader;
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    HeaderElement[] codecs = ceheader.getElements();
                    for (int i = 0; i < codecs.length; ++i) {
                        if (!codecs[i].getName().equalsIgnoreCase(HttpConnectionPool.COMPRESSION_TYPE)) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                }
            }
        });
    }

    public boolean isRequestGzipEnabled() {
        return this.requestGzipEnabled;
    }

    public void setRequestGzipEnabled(boolean requestGzipEnabled) {
        this.requestGzipEnabled = requestGzipEnabled;
    }

    public boolean isResponseGzipEnabled() {
        return this.responseGzipEnabled;
    }

    public void setResponseGzipEnabled(boolean responseGzipEnabled) {
        this.responseGzipEnabled = responseGzipEnabled;
    }
}

