/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.log4j;

import com.flipkart.poseidon.log4j.message.AccessLog;
import java.io.File;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.message.Message;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class Log4JAccessLog
extends AbstractLifeCycle
implements RequestLog {
    private final String accessConfigFilePath;
    private final Supplier<Boolean> isEnabledSupplier;
    private LoggerContext loggerContext;
    private Logger logger;

    public Log4JAccessLog(String accessConfigFilePath, Supplier<Boolean> isEnabledSupplier) {
        this.accessConfigFilePath = accessConfigFilePath;
        this.isEnabledSupplier = isEnabledSupplier;
    }

    protected void doStart() throws Exception {
        File accessConfigFile = new File(this.accessConfigFilePath);
        if (!accessConfigFile.isFile()) {
            throw new Exception("Log4J access config file not found: " + this.accessConfigFilePath);
        }
        this.loggerContext = new Log4jContextFactory().getContext(Log4JAccessLog.class.getName(), null, null, true, accessConfigFile.toURI(), "PoseidonLog4JAccess");
        this.logger = this.loggerContext.getRootLogger();
    }

    protected void doStop() throws Exception {
        this.loggerContext.stop();
    }

    private boolean isEnabled() {
        return this.isEnabledSupplier.get();
    }

    public final void log(Request request, Response response) {
        if (!this.isEnabled()) {
            return;
        }
        this.logger.log(Level.INFO, (Message)new AccessLog(request, response));
    }
}

