/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.sampleSC.v1;

import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.serviceclients.AbstractServiceClient;
import com.flipkart.poseidon.serviceclients.FutureTaskResultToDomainObjectPromiseWrapper;
import com.flipkart.poseidon.serviceclients.ServiceExecutePropertiesBuilder;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.Posts;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceBadRequestException;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceClient;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceException;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceFailureException;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceResourceNotFoundException;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.UserList;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;

@Name(value="sampleSC")
@Version(major=1, minor=0, patch=0)
@Description(value="Sample Service Client", verbose="Sample Service Client")
public class SampleServiceClientImpl
extends AbstractServiceClient
implements SampleServiceClient {
    private SampleServiceClientImpl() {
        this.exceptions.put("400", SampleServiceBadRequestException.class);
        this.exceptions.put("404", SampleServiceResourceNotFoundException.class);
        this.exceptions.put("500", SampleServiceFailureException.class);
        this.exceptions.put("default", SampleServiceException.class);
    }

    @Override
    public FutureTaskResultToDomainObjectPromiseWrapper<UserList> getUser(@NotNull String id) throws Exception {
        String uri = "/users";
        Validate.notEmpty((String)id, (String)"id can not be null/empty");
        uri = uri + this.getQueryURI(Arrays.asList("id=" + this.encodeUrl(id)));
        return this.execute(new ServiceExecutePropertiesBuilder().setJavaType(this.getJavaType(UserList.class)).setUri(uri).setHttpMethod("GET").setCommandName("userServiceHttpRequest").build());
    }

    @Override
    public FutureTaskResultToDomainObjectPromiseWrapper<Posts> getAllPostsOfUser(@NotNull String userId) throws Exception {
        String uri = "/posts";
        Validate.notEmpty((String)userId, (String)"userId can not be null/empty");
        uri = uri + this.getQueryURI(Arrays.asList("userId=" + this.encodeUrl(userId)));
        return this.execute(new ServiceExecutePropertiesBuilder().setJavaType(this.getJavaType(Posts.class)).setUri(uri).setHttpMethod("GET").setCommandName("postsServiceHttpRequest").build());
    }

    public String getCommandName() {
        return "sampleServiceHttpRequest";
    }
}

