/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.sample.datasources;

import com.flipkart.poseidon.datasources.AbstractDataSource;
import com.flipkart.poseidon.exception.DataSourceException;
import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.sample.datatypes.PostDataType;
import com.flipkart.poseidon.sample.datatypes.PostsDataType;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.Post;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.Posts;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceClient;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceException;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceFailureException;
import com.flipkart.poseidon.serviceclients.sampleSC.v1.SampleServiceResourceNotFoundException;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="PostsDS")
@Version(major=1, minor=0, patch=0)
@Description(value="Fetches all posts for a given user id")
public class PostsDataSource
extends AbstractDataSource<PostsDataType> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PostsDataSource(LegoSet legoset, Request request) {
        super(legoset, request);
    }

    public PostsDataType call() throws Exception {
        try {
            String userId = (String)this.request.getAttribute("userId");
            SampleServiceClient serviceClient = (SampleServiceClient)this.legoset.getServiceClient("sampleSC_1.0.0");
            Posts posts = (Posts)serviceClient.getAllPostsOfUser(userId).get();
            if (posts == null || posts.isEmpty()) {
                return null;
            }
            PostsDataType postsDataType = new PostsDataType();
            ArrayList<PostDataType> postDataTypeList = new ArrayList<PostDataType>();
            for (Post post : posts) {
                PostDataType postDataType = new PostDataType();
                postDataType.setUserId(post.getUserId());
                postDataType.setPostId(post.getId());
                postDataType.setPostBody(post.getTitle());
                postDataType.setPostTitle(post.getTitle());
                postDataTypeList.add(postDataType);
            }
            postsDataType.setPosts(postDataTypeList);
            return postsDataType;
        }
        catch (SampleServiceResourceNotFoundException notFoundException) {
            throw new DataSourceException((Object)"User not found");
        }
        catch (SampleServiceFailureException failureException) {
            throw new DataSourceException((Object)"Failed to fetch user details due to service failure");
        }
        catch (SampleServiceException serviceException) {
            this.logger.error("Error fetching user details", (Throwable)serviceException);
            throw new DataSourceException((Object)"Failed to fetch user details");
        }
    }
}

