/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.sample.api.filters;

import com.flipkart.poseidon.core.PoseidonRequest;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.filters.AbstractFilter;
import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import flipkart.lego.api.entities.Response;
import flipkart.lego.api.exceptions.BadRequestException;
import flipkart.lego.api.exceptions.InternalErrorException;
import flipkart.lego.api.exceptions.ProcessingException;
import java.util.Map;
import java.util.Optional;

@Name(value="BotFilter")
@Version(major=1, minor=0, patch=0)
@Description(value="Detects and filters out bots in a dumb way")
public class BotFilter
extends AbstractFilter {
    public BotFilter(LegoSet legoset) {
        super(legoset);
    }

    public void filterRequest(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
        String userAgent = ((PoseidonRequest)request).getHeader("User-Agent");
        if (userAgent != null && userAgent.contains("bot")) {
            Map endpointAnnotations = (Map)RequestContext.get((String)"poseidon.endpoint.annotations");
            String message = Optional.ofNullable(endpointAnnotations.get("errorMessage")).orElse("Bots are not allowed");
            throw new BadRequestException(message);
        }
    }

    public void filterResponse(Request request, Response response) throws InternalErrorException, BadRequestException, ProcessingException {
    }
}

