/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.sample.datasources;

import com.flipkart.poseidon.datasources.AbstractDataSource;
import com.flipkart.poseidon.exception.DataSourceException;
import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.sample.datatypes.CommentDataType;
import com.flipkart.poseidon.sample.datatypes.PostDataType;
import com.flipkart.poseidon.sample.datatypes.PostWithCommentsDataType;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.Comments;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceClient;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceException;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceFailureException;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceResourceNotFoundException;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="CommentsDS")
@Version(major=1, minor=0, patch=0)
@Description(value="Fetches all comments for a given post")
public class CommentsDataSource
extends AbstractDataSource<PostWithCommentsDataType> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public CommentsDataSource(LegoSet legoset, Request request) {
        super(legoset, request);
    }

    public PostWithCommentsDataType call() throws Exception {
        try {
            int index = (Integer)this.request.getAttribute("index");
            PostDataType post = (PostDataType)this.request.getAttribute("post");
            this.logger.info("Index: {}, Post Id: {}", (Object)index, (Object)post.getPostId());
            SampleServiceClient serviceClient = (SampleServiceClient)this.legoset.getServiceClient("sampleSC_5.14.0");
            Comments comments = (Comments)serviceClient.getAllCommentsOfPost(Integer.valueOf(post.getPostId())).get();
            PostWithCommentsDataType postWithComments = new PostWithCommentsDataType();
            postWithComments.setPost(post);
            postWithComments.setComments(comments.stream().map(comment -> {
                CommentDataType commentDataType = new CommentDataType();
                commentDataType.setCommentId(comment.getId());
                commentDataType.setPostId(comment.getPostId());
                commentDataType.setName(comment.getName());
                commentDataType.setEmail(comment.getEmail());
                commentDataType.setBody(comment.getBody());
                return commentDataType;
            }).collect(Collectors.toList()));
            return postWithComments;
        }
        catch (SampleServiceResourceNotFoundException notFoundException) {
            throw new DataSourceException((Object)"Post not found");
        }
        catch (SampleServiceFailureException failureException) {
            throw new DataSourceException((Object)"Failed to fetch comments due to service failure");
        }
        catch (SampleServiceException serviceException) {
            this.logger.error("Error fetching user details", (Throwable)serviceException);
            throw new DataSourceException((Object)"Failed to fetch comments");
        }
    }
}

