/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.sample.datasources;

import com.flipkart.poseidon.datasources.AbstractDataSource;
import com.flipkart.poseidon.exception.DataSourceException;
import com.flipkart.poseidon.model.annotations.Description;
import com.flipkart.poseidon.model.annotations.Name;
import com.flipkart.poseidon.model.annotations.Version;
import com.flipkart.poseidon.sample.datatypes.UserDataType;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceClient;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceException;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceFailureException;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.SampleServiceResourceNotFoundException;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.User;
import com.flipkart.poseidon.serviceclients.sampleSC.v5.UserList;
import flipkart.lego.api.entities.LegoSet;
import flipkart.lego.api.entities.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="UserDS")
@Version(major=1, minor=0, patch=0)
@Description(value="Fetches an user for a given id")
public class UserDataSource
extends AbstractDataSource<UserDataType> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public UserDataSource(LegoSet legoset, Request request) {
        super(legoset, request);
    }

    public UserDataType call() throws Exception {
        try {
            String userId = (String)this.request.getAttribute("userId");
            SampleServiceClient serviceClient = (SampleServiceClient)this.legoset.getServiceClient("sampleSC_5.14.0");
            UserList userList = (UserList)serviceClient.getUser(userId).get();
            if (userList == null || userList.isEmpty()) {
                throw new DataSourceException((Object)"User not found", 404);
            }
            User user = (User)userList.get(0);
            UserDataType userDataType = new UserDataType();
            userDataType.setUserId(user.getId());
            userDataType.setUserName(user.getName());
            userDataType.setEmailId(user.getEmail());
            return userDataType;
        }
        catch (SampleServiceResourceNotFoundException notFoundException) {
            throw new DataSourceException((Object)"User not found");
        }
        catch (SampleServiceFailureException failureException) {
            throw new DataSourceException((Object)"Failed to fetch user details due to service failure");
        }
        catch (SampleServiceException serviceException) {
            this.logger.error("Error fetching user details", (Throwable)serviceException);
            throw new DataSourceException((Object)"Failed to fetch user details");
        }
    }
}

