/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.phantom.task.impl.TaskContextFactory;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.poseidon.core.RequestContext;
import com.flipkart.poseidon.serviceclients.FutureTaskResultToDomainObjectPromiseWrapper;
import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.flipkart.poseidon.serviceclients.ServiceResponseDecoder;
import com.google.common.base.Joiner;
import flipkart.lego.api.entities.ServiceClient;
import flipkart.lego.api.exceptions.LegoServiceException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceClient
implements ServiceClient {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected Map<String, Class<? extends ServiceClientException>> exceptions = new HashMap<String, Class<? extends ServiceClientException>>();

    protected abstract String getCommandName();

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(Class<T> clazz, String uri, String httpMethod, Map<String, String> headersMap, Object requestObject) throws IOException {
        return this.execute(clazz, uri, httpMethod, headersMap, requestObject, null);
    }

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(Class<T> clazz, String uri, String httpMethod, Map<String, String> headersMap, Object requestObject, String commandName) throws IOException {
        return this.execute(clazz, uri, httpMethod, headersMap, requestObject, commandName, false);
    }

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(Class<T> clazz, String uri, String httpMethod, Map<String, String> headersMap, Object requestObject, String commandName, boolean requestCachingEnabled) throws IOException {
        Map<String, String> injectedHeadersMap;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (commandName == null || commandName.isEmpty()) {
            commandName = this.getCommandName();
        }
        logger.info("Executing {} with {} {}", new Object[]{commandName, httpMethod, uri});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uri", uri);
        params.put("method", httpMethod);
        if (requestCachingEnabled) {
            params.put("X-Cache-Request", "true");
        }
        if (!(injectedHeadersMap = this.injectHeaders(headersMap)).isEmpty()) {
            try {
                params.put("headers", objectMapper.writeValueAsString(injectedHeadersMap));
            }
            catch (Exception e) {
                logger.error("Error serializing headers", (Throwable)e);
                throw new IOException("Headers serialization error", e);
            }
        }
        byte[] payload = null;
        if (requestObject != null) {
            try {
                payload = requestObject instanceof String ? ((String)requestObject).getBytes() : objectMapper.writeValueAsBytes(requestObject);
            }
            catch (Exception e) {
                logger.error("Error serializing request object", (Throwable)e);
                throw new IOException("Request object serialization error", e);
            }
        }
        TaskContext taskContext = TaskContextFactory.getTaskContext();
        ServiceResponseDecoder<T> serviceResponseDecoder = new ServiceResponseDecoder<T>(objectMapper, clazz, logger, this.exceptions);
        Future future = taskContext.executeAsyncCommand(commandName, (Object)payload, params, serviceResponseDecoder);
        return new FutureTaskResultToDomainObjectPromiseWrapper(future);
    }

    protected Map<String, String> injectHeaders(Map<String, String> headersMap) {
        Boolean isPerfTest;
        String requestId;
        HashMap<String, String> injectedHeadersMap = new HashMap<String, String>();
        if (headersMap != null && !headersMap.isEmpty()) {
            injectedHeadersMap.putAll(headersMap);
        }
        if ((requestId = (String)RequestContext.get((String)"requestId")) != null && !requestId.isEmpty()) {
            injectedHeadersMap.put("X-REQUEST-ID", requestId);
        }
        if ((isPerfTest = (Boolean)RequestContext.get((String)"isPerfTest")) != null && isPerfTest.booleanValue()) {
            injectedHeadersMap.put("X-PERF-TEST", "true");
        }
        return injectedHeadersMap;
    }

    protected String encodeUrl(String url) {
        if (url == null || url.isEmpty()) {
            return "";
        }
        try {
            return URLEncoder.encode(url, "UTF-8").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception while encoding URL: " + url, (Throwable)e);
            return url;
        }
    }

    protected String getOptURI(String paramName, Object paramValue) {
        if (paramValue == null || paramValue instanceof String && paramValue.toString().isEmpty()) {
            return "";
        }
        return paramName + "=" + paramValue;
    }

    protected String getQueryURI(List<String> params) {
        StringBuilder queryURI = new StringBuilder();
        Boolean first = true;
        for (String param : params) {
            if (param == null || param.isEmpty()) continue;
            if (first.booleanValue()) {
                queryURI.append("?");
                first = false;
            } else {
                queryURI.append("&");
            }
            queryURI.append(param);
        }
        return queryURI.toString();
    }

    public void init() throws LegoServiceException {
        throw new UnsupportedOperationException();
    }

    public void shutDown() throws LegoServiceException {
        throw new UnsupportedOperationException();
    }

    public String getId() throws UnsupportedOperationException {
        return this.getName() + "_" + Joiner.on((String)".").join((Iterable)this.getVersion());
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

