/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.executor;

import com.flipkart.poseidon.serviceclients.executor.CommandFailedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutor.class);

    public static String execute(File directory, String ... command) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(directory);
        Process process = processBuilder.start();
        String output = CommandExecutor.readOutput(process);
        int exitCode = -1;
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException e) {
            logger.error("Exception waiting for process", (Throwable)e);
        }
        if (exitCode != 0) {
            throw new CommandFailedException(output, exitCode);
        }
        return output;
    }

    private static String readOutput(Process process) throws IOException {
        String line;
        InputStream stream = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder buffer = new StringBuilder();
        while ((line = br.readLine()) != null) {
            buffer.append(line);
        }
        return buffer.toString();
    }
}

