/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(JsonValidator.class);
    private static final JsonValidator JSON_VALIDATOR = new JsonValidator();

    private JsonValidator() {
    }

    public static JsonValidator getInstance() {
        return JSON_VALIDATOR;
    }

    private void validate(String schemaPath, String filePath) throws IOException, ProcessingException {
        JsonNode schema = JsonLoader.fromResource((String)schemaPath);
        JsonNode json = JsonLoader.fromPath((String)filePath);
        com.github.fge.jsonschema.main.JsonValidator validator = JsonSchemaFactory.byDefault().getValidator();
        ProcessingReport report = validator.validate(schema, json);
        if (report == null || !report.isSuccess()) {
            logger.error("Invalid JSON");
            if (report != null) {
                throw new ProcessingException(report.toString());
            }
            throw new ProcessingException("JSON validation report is null for " + filePath);
        }
    }

    public void validateService(String filePath) throws IOException, ProcessingException {
        this.validate("/ServiceJsonSchema.json", filePath);
    }

    public void validatePojo(String filePath) throws IOException, ProcessingException {
        this.validate("/PojoJsonSchema.json", filePath);
    }
}

