/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.phantom.task.impl.TaskContextFactory;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.poseidon.serviceclients.FutureTaskResultToDomainObjectPromiseWrapper;
import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.flipkart.poseidon.serviceclients.ServiceContext;
import com.flipkart.poseidon.serviceclients.ServiceExecuteProperties;
import com.flipkart.poseidon.serviceclients.ServiceExecutePropertiesBuilder;
import com.flipkart.poseidon.serviceclients.ServiceResponseDecoder;
import com.google.common.base.Joiner;
import flipkart.lego.api.entities.ServiceClient;
import flipkart.lego.api.exceptions.LegoServiceException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceClient
implements ServiceClient {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected Map<String, Class<? extends ServiceClientException>> exceptions = new HashMap<String, Class<? extends ServiceClientException>>();

    protected abstract String getCommandName();

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(JavaType javaType, String uri, String httpMethod, Map<String, String> headersMap, Object requestObject) throws IOException {
        return this.execute(new ServiceExecutePropertiesBuilder().setJavaType(javaType).setUri(uri).setHttpMethod(httpMethod).setHeadersMap(headersMap).setRequestObject(requestObject).setRequestCachingEnabled(false).build());
    }

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(JavaType javaType, String uri, String httpMethod, Map<String, String> headersMap, Object requestObject, String commandName) throws IOException {
        return this.execute(new ServiceExecutePropertiesBuilder().setJavaType(javaType).setUri(uri).setHttpMethod(httpMethod).setHeadersMap(headersMap).setRequestObject(requestObject).setCommandName(commandName).setRequestCachingEnabled(false).build());
    }

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(JavaType javaType, String uri, String httpMethod, Map<String, String> headersMap, Object requestObject, String commandName, boolean requestCachingEnabled) throws IOException {
        return this.execute(new ServiceExecutePropertiesBuilder().setJavaType(javaType).setUri(uri).setHttpMethod(httpMethod).setHeadersMap(headersMap).setRequestObject(requestObject).setCommandName(commandName).setRequestCachingEnabled(requestCachingEnabled).build());
    }

    protected final <T> FutureTaskResultToDomainObjectPromiseWrapper<T> execute(ServiceExecuteProperties properties) throws IOException {
        Map<String, String> injectedHeadersMap;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        String commandName = properties.getCommandName();
        String uri = properties.getUri();
        String httpMethod = properties.getHttpMethod();
        boolean requestCachingEnabled = properties.isRequestCachingEnabled();
        Map<String, String> headersMap = properties.getHeadersMap();
        Object requestObject = properties.getRequestObject();
        JavaType javaType = properties.getJavaType();
        JavaType errorType = properties.getErrorType();
        if (commandName == null || commandName.isEmpty()) {
            commandName = this.getCommandName();
        }
        if (ServiceContext.get("collect-commands") != null && ((Boolean)ServiceContext.get("collect-commands")).booleanValue()) {
            ConcurrentLinkedQueue commandNames = (ConcurrentLinkedQueue)ServiceContext.get("commands");
            commandNames.add(commandName);
        }
        logger.info("Executing {} with {} {}", new Object[]{commandName, httpMethod, uri});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uri", uri);
        params.put("method", httpMethod);
        if (requestCachingEnabled) {
            params.put("X-Cache-Request", "true");
        }
        if (!(injectedHeadersMap = this.injectHeaders(headersMap)).isEmpty()) {
            try {
                params.put("headers", this.getObjectMapper().writeValueAsString(injectedHeadersMap));
            }
            catch (Exception e) {
                logger.error("Error serializing headers", (Throwable)e);
                throw new IOException("Headers serialization error", e);
            }
        }
        byte[] payload = null;
        if (requestObject != null) {
            try {
                payload = requestObject instanceof String ? ((String)requestObject).getBytes() : (requestObject instanceof byte[] ? (byte[])requestObject : this.getObjectMapper().writeValueAsBytes(requestObject));
            }
            catch (Exception e) {
                logger.error("Error serializing request object", (Throwable)e);
                throw new IOException("Request object serialization error", e);
            }
        }
        TaskContext taskContext = TaskContextFactory.getTaskContext();
        ServiceResponseDecoder serviceResponseDecoder = new ServiceResponseDecoder(this.getObjectMapper(), javaType, errorType, logger, this.exceptions);
        Future future = taskContext.executeAsyncCommand(commandName, (Object)payload, params, serviceResponseDecoder);
        return new FutureTaskResultToDomainObjectPromiseWrapper(future);
    }

    protected Map<String, String> injectHeaders(Map<String, String> headersMap) {
        HashMap<String, String> injectedHeadersMap = new HashMap<String, String>();
        if (headersMap != null && !headersMap.isEmpty()) {
            injectedHeadersMap.putAll(headersMap);
        }
        if (ServiceContext.get("headers") instanceof Map) {
            Map configuredHeaders = (Map)ServiceContext.get("headers");
            injectedHeadersMap.putAll(configuredHeaders);
        }
        return injectedHeadersMap;
    }

    protected String encodeUrl(String url) {
        if (url == null || url.isEmpty()) {
            return "";
        }
        try {
            return URLEncoder.encode(url, "UTF-8").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception while encoding URL: " + url, (Throwable)e);
            return url;
        }
    }

    protected String getOptURI(String paramName, Object paramValue) {
        if (paramValue == null || paramValue instanceof String && paramValue.toString().isEmpty()) {
            return "";
        }
        return paramName + "=" + paramValue;
    }

    protected String getQueryURI(List<String> params) {
        StringBuilder queryURI = new StringBuilder();
        Boolean first = true;
        for (String param : params) {
            if (param == null || param.isEmpty()) continue;
            if (first.booleanValue()) {
                queryURI.append("?");
                first = false;
            } else {
                queryURI.append("&");
            }
            queryURI.append(param);
        }
        return queryURI.toString();
    }

    protected <T> String getMultiValueParamURI(String paramName, List<T> paramValues) {
        StringBuilder queryURI = new StringBuilder();
        if (paramValues != null && !paramValues.isEmpty()) {
            boolean first = true;
            for (T paramValue : paramValues) {
                if (paramValue == null) continue;
                if (first) {
                    first = false;
                } else {
                    queryURI.append("&");
                }
                queryURI.append(paramName).append("=");
                if (paramValue instanceof String) {
                    queryURI.append(this.encodeUrl((String)paramValue));
                    continue;
                }
                queryURI.append(paramValue);
            }
        }
        return queryURI.toString();
    }

    public JavaType getJavaType(TypeReference typeReference) {
        return objectMapper.getTypeFactory().constructType(typeReference);
    }

    public JavaType getErrorType(TypeReference typeReference) {
        return objectMapper.getTypeFactory().constructType(typeReference);
    }

    public <T> JavaType getJavaType(Class<T> clazz) {
        return objectMapper.getTypeFactory().constructType(clazz);
    }

    public <T> JavaType getErrorType(Class<T> clazz) {
        return objectMapper.getTypeFactory().constructType(clazz);
    }

    public void init() throws LegoServiceException {
        throw new UnsupportedOperationException();
    }

    public void shutDown() throws LegoServiceException {
        throw new UnsupportedOperationException();
    }

    public String getId() throws UnsupportedOperationException {
        return this.getName() + "_" + Joiner.on((String)".").join((Iterable)this.getVersion());
    }

    protected ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

