/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.flipkart.poseidon.serviceclients.ServiceDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceContext {
    private static final ThreadLocal<Map<String, Object>> context = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static final ThreadLocal<Boolean> isImmutable = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final ThreadLocal<Boolean> isDebug = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Map<String, List<ServiceDebug>>> debugResponses = ThreadLocal.withInitial(ConcurrentHashMap::new);

    public static void initialize() {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.remove();
        isImmutable.set(false);
    }

    public static void initialize(Map<String, Object> ctxt, boolean debug, Map<String, List<ServiceDebug>> serviceResponses) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.remove();
        context.get().putAll(ctxt);
        if (debug) {
            isDebug.set(debug);
            debugResponses.remove();
            debugResponses.set(serviceResponses);
        }
        isImmutable.set(false);
    }

    public static void set(String key, Object value) {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        context.get().put(key, value);
    }

    public static void enableDebug() {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        isDebug.set(true);
    }

    public static void disableDebug() {
        if (isImmutable.get().booleanValue()) {
            throw new UnsupportedOperationException();
        }
        isDebug.set(false);
    }

    public static boolean isDebug() {
        return isDebug.get();
    }

    public static void addDebugResponse(String key, ServiceDebug response) {
        if (!ServiceContext.isDebug()) {
            return;
        }
        debugResponses.get().computeIfAbsent(key, k -> new ArrayList()).add(response);
    }

    public static Map<String, List<ServiceDebug>> getDebugResponses() {
        return debugResponses.get();
    }

    public static <T> T get(String key) {
        return (T)context.get().get(key);
    }

    public static Map<String, Object> getContextMap() {
        return new HashMap<String, Object>(context.get());
    }

    public static void shutDown() {
        context.remove();
        isImmutable.remove();
        isDebug.remove();
        debugResponses.remove();
    }
}

