/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients;

import com.flipkart.phantom.task.spi.TaskResult;
import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.flipkart.poseidon.serviceclients.ServiceResponse;
import com.flipkart.poseidon.serviceclients.batch.ResponseMerger;
import flipkart.lego.concurrency.api.Promise;
import flipkart.lego.concurrency.api.PromiseListener;
import flipkart.lego.concurrency.exceptions.PromiseBrokenException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FutureTaskResultToDomainObjectPromiseWrapper<DomainObject>
implements Promise<DomainObject> {
    private final List<Future<TaskResult>> futureList = new ArrayList<Future<TaskResult>>();
    private PromiseBrokenException promiseBrokenException;
    private ResponseMerger<DomainObject> responseMerger;

    public FutureTaskResultToDomainObjectPromiseWrapper(Future<TaskResult> future) {
        this.futureList.add(future);
    }

    public FutureTaskResultToDomainObjectPromiseWrapper(ResponseMerger<DomainObject> responseMerger) {
        this.responseMerger = responseMerger;
    }

    public boolean isRealized() {
        for (Future<TaskResult> future : this.futureList) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullfilled() throws IllegalStateException {
        for (Future<TaskResult> future : this.futureList) {
            if (!future.isCancelled()) continue;
            return false;
        }
        return true;
    }

    public boolean isBroken() throws IllegalStateException {
        for (Future<TaskResult> future : this.futureList) {
            if (!future.isCancelled()) continue;
            return true;
        }
        return false;
    }

    public void await() throws InterruptedException {
        try {
            for (Future<TaskResult> future : this.futureList) {
                future.get();
            }
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
        }
    }

    public void await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        try {
            for (Future<TaskResult> future : this.futureList) {
                future.get(timeout, timeUnit);
            }
        }
        catch (ExecutionException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public DomainObject get() throws PromiseBrokenException, InterruptedException {
        try {
            ServiceResponse serviceResponse = new ServiceResponse();
            for (Future<TaskResult> futureResult : this.futureList) {
                TaskResult result = futureResult.get();
                if (result == null) {
                    throw new PromiseBrokenException("Task result is null");
                }
                ServiceResponse response = (ServiceResponse)result.getData();
                if (!response.getIsSuccess()) {
                    throw response.getException();
                }
                serviceResponse.addData(response.getDataList());
            }
            if (this.responseMerger != null) {
                return this.responseMerger.mergeResponse(serviceResponse.getDataList());
            }
            return (DomainObject)serviceResponse.getDataList().get(0);
        }
        catch (ExecutionException exception) {
            this.checkAndThrowServiceClientException(exception);
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new PromiseBrokenException((Throwable)this.promiseBrokenException);
        }
    }

    public DomainObject get(long timeout, TimeUnit timeUnit) throws PromiseBrokenException, TimeoutException, InterruptedException {
        try {
            ServiceResponse serviceResponse = new ServiceResponse();
            for (Future<TaskResult> futureResult : this.futureList) {
                TaskResult result = futureResult.get(timeout, timeUnit);
                if (result == null) {
                    throw new PromiseBrokenException("Task result is null");
                }
                ServiceResponse response = (ServiceResponse)result.getData();
                if (!response.getIsSuccess()) {
                    throw response.getException();
                }
                serviceResponse.addData(response.getDataList());
            }
            if (this.responseMerger != null) {
                return this.responseMerger.mergeResponse(serviceResponse.getDataList());
            }
            return (DomainObject)serviceResponse.getDataList().get(0);
        }
        catch (ExecutionException exception) {
            this.checkAndThrowServiceClientException(exception);
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new PromiseBrokenException((Throwable)this.promiseBrokenException);
        }
    }

    public Map<String, String> getHeaders() throws PromiseBrokenException, InterruptedException {
        try {
            TaskResult taskResult = this.futureList.get(0).get();
            if (taskResult == null) {
                throw new PromiseBrokenException("Task result is null");
            }
            ServiceResponse response = (ServiceResponse)taskResult.getData();
            return response.getHeaders();
        }
        catch (ExecutionException exception) {
            this.checkAndThrowServiceClientException(exception);
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new InterruptedException(exception.getMessage());
        }
        catch (CancellationException exception) {
            this.promiseBrokenException = new PromiseBrokenException((Throwable)exception);
            throw new PromiseBrokenException((Throwable)this.promiseBrokenException);
        }
    }

    public synchronized void addListener(PromiseListener promiseListener) {
        throw new UnsupportedOperationException("Adding listeners is not supported");
    }

    public void addFutureForTask(Future<TaskResult> future) {
        this.futureList.add(future);
    }

    public void addFutureForTask(List<Future<TaskResult>> future) {
        this.futureList.addAll(future);
    }

    public List<Future<TaskResult>> getFutureList() {
        return this.futureList;
    }

    private void checkAndThrowServiceClientException(ExecutionException exception) throws ServiceClientException {
        Throwable generatedException = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)exception)).orElse(exception);
        if (generatedException instanceof ServiceClientException) {
            throw (ServiceClientException)((Object)generatedException);
        }
    }
}

