/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.poseidon.serviceclients.generator;

import com.flipkart.poseidon.serviceclients.ServiceClientException;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class ExceptionGenerator {
    private static ExceptionGenerator INSTANCE = new ExceptionGenerator();

    private ExceptionGenerator() {
    }

    public static ExceptionGenerator getInstance() {
        return INSTANCE;
    }

    private void addAnnotations(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        JAnnotationUse annotationUse = jDefinedClass.annotate(jCodeModel.ref("javax.annotation.Generated"));
        annotationUse.param("value", this.getClass().getName());
        annotationUse.param("date", new Date().toString());
        annotationUse.param("comments", "EDIT THIS IF YOU ARE ****");
    }

    private void addConstructor(JDefinedClass jDefinedClass) {
        JMethod constructor = jDefinedClass.constructor(1);
        String messageVar = "message";
        constructor.param(String.class, messageVar);
        JBlock block = constructor.body();
        JInvocation superCall = block.invoke("super");
        superCall.arg((JExpression)JExpr.ref((String)messageVar));
        superCall.arg(JExpr._null());
    }

    private void addConstructorErrorObject(JDefinedClass jDefinedClass) {
        JMethod constructor = jDefinedClass.constructor(1);
        String messageVar = "message";
        constructor.param(String.class, messageVar);
        String objectVar = "errorResponse";
        constructor.param(Object.class, objectVar);
        JBlock block = constructor.body();
        JInvocation superCall = block.invoke("super");
        superCall.arg((JExpression)JExpr.ref((String)messageVar));
        superCall.arg((JExpression)JExpr.ref((String)objectVar));
    }

    private void addConstructorThrowable(JDefinedClass jDefinedClass) {
        JMethod constructor = jDefinedClass.constructor(1);
        String messageVar = "message";
        constructor.param(String.class, messageVar);
        String throwableVar = "e";
        constructor.param(Throwable.class, throwableVar);
        JBlock block = constructor.body();
        JInvocation superCall = block.invoke("super");
        superCall.arg((JExpression)JExpr.ref((String)messageVar));
        superCall.arg((JExpression)JExpr.ref((String)throwableVar));
    }

    public void addExceptionClass(String destinationFolder, String className) throws JClassAlreadyExistsException, IOException {
        JCodeModel model = new JCodeModel();
        JDefinedClass definedClass = model._class(className, ClassType.CLASS);
        definedClass._extends(model.ref(ServiceClientException.class));
        this.addAnnotations(model, definedClass);
        this.addConstructor(definedClass);
        this.addConstructorErrorObject(definedClass);
        this.addConstructorThrowable(definedClass);
        model.build(new File(destinationFolder), (PrintStream)null);
    }
}

