/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.priority.kafka.client.consumer.burst;

import java.util.SortedMap;
import java.util.TreeMap;

class Window {
    private int circularIdx = -1;
    private int[] values;
    private SortedMap<Integer, Integer> sortedValues;
    private int maxedOutCountThreshold;
    private int valueLimit;
    private int maxedOutCount;

    Window(final int size, int maxedOutCountThreshold, int valueLimit) {
        this.values = new int[size];
        this.sortedValues = new TreeMap<Integer, Integer>(){
            {
                this.put(0, size);
            }
        };
        this.maxedOutCountThreshold = maxedOutCountThreshold;
        this.valueLimit = valueLimit;
        this.maxedOutCount = 0;
    }

    void add(int value) {
        int nextIdx = (this.circularIdx + 1) % this.values.length;
        if (value >= this.valueLimit && this.values[nextIdx] < this.valueLimit) {
            ++this.maxedOutCount;
        } else if (value < this.valueLimit && this.values[nextIdx] >= this.valueLimit) {
            --this.maxedOutCount;
        }
        this.sortedValues.put(this.values[nextIdx], (Integer)this.sortedValues.get(this.values[nextIdx]) - 1);
        if ((Integer)this.sortedValues.get(this.values[nextIdx]) == 0) {
            this.sortedValues.remove(this.values[nextIdx]);
        }
        if (!this.sortedValues.containsKey(value)) {
            this.sortedValues.put(value, 0);
        }
        this.sortedValues.put(value, (Integer)this.sortedValues.get(value) + 1);
        this.values[nextIdx] = value;
        this.circularIdx = nextIdx;
    }

    boolean isMaxedOutThresholdBreach() {
        return this.maxedOutCount >= this.maxedOutCountThreshold;
    }

    int maxUnusedValue() {
        return Math.max(0, this.valueLimit - this.sortedValues.lastKey());
    }
}

