/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilience4all.metrics.eventstream;

import com.codahale.metrics.Snapshot;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.resilience4all.metrics.eventstream.HystrixMetrics;
import com.flipkart.resilience4all.metrics.eventstream.LatencyHistogram;
import com.netflix.hystrix.HystrixCommandProperties;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.metrics.Timer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import rx.exceptions.OnErrorNotImplementedException;

public class HystrixCommandLikeMetrics
implements HystrixMetrics {
    @JsonIgnore
    private final CircuitBreaker circuitBreaker;
    @JsonIgnore
    private final Bulkhead bulkhead;
    @JsonIgnore
    private final ThreadPoolBulkhead threadPoolBulkhead;
    @JsonIgnore
    private final Retry retry;
    @JsonIgnore
    private final TimeLimiter timeLimiter;
    @JsonIgnore
    private final Timer clientTimer;
    @JsonIgnore
    private final Timer serverTimer;

    public HystrixCommandLikeMetrics(String commandName, CircuitBreaker circuitBreaker, Bulkhead bulkhead, ThreadPoolBulkhead threadPoolBulkhead, Retry retry, TimeLimiter timeLimiter, Timer clientTimer, Timer serverTimer) {
        this.clientTimer = clientTimer;
        this.serverTimer = serverTimer;
        if (Objects.isNull(circuitBreaker) && Objects.isNull(bulkhead) && Objects.isNull(threadPoolBulkhead) && Objects.isNull(retry)) {
            throw new OnErrorNotImplementedException("Please provide at least one of circuitbreaker, bulkhead, threadpoolbulkhead and retry for: " + commandName, (Throwable)new IllegalArgumentException(commandName));
        }
        this.circuitBreaker = circuitBreaker;
        this.bulkhead = bulkhead;
        this.threadPoolBulkhead = threadPoolBulkhead;
        this.retry = retry;
        this.timeLimiter = timeLimiter;
    }

    @Override
    public String getType() {
        return "HystrixCommand";
    }

    @Override
    public String getName() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getName();
        }
        if (Objects.nonNull(this.bulkhead)) {
            return this.bulkhead.getName();
        }
        if (Objects.nonNull(this.threadPoolBulkhead)) {
            return this.threadPoolBulkhead.getName();
        }
        if (Objects.nonNull(this.retry)) {
            return this.retry.getName();
        }
        throw new IllegalStateException("All of the 4 resilience4j objects can not be null.");
    }

    public String getGroup() {
        return this.getName();
    }

    public Long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @JsonProperty(value="isCircuitBreakerOpen")
    public boolean isCircuitBreakerOpen() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getState() == CircuitBreaker.State.OPEN;
        }
        return false;
    }

    public Float getErrorPercentage() {
        float failureRate;
        if (Objects.nonNull(this.circuitBreaker) && (double)(failureRate = this.circuitBreaker.getMetrics().getFailureRate()) > 0.0) {
            return Float.valueOf(failureRate);
        }
        return Float.valueOf(0.0f);
    }

    public long getErrorCount() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getMetrics().getNumberOfFailedCalls();
        }
        return 0L;
    }

    public long getRequestCount() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getMetrics().getNumberOfBufferedCalls();
        }
        return 0L;
    }

    public long getRollingCountBadRequests() {
        return 0L;
    }

    public long getRollingCountCollapsedRequests() {
        return 0L;
    }

    public long getRollingCountEmit() {
        return 0L;
    }

    public long getRollingCountExceptionsThrown() {
        return this.getErrorCount();
    }

    public long getRollingCountFailure() {
        return this.getErrorCount();
    }

    public long getRollingCountFallbackEmit() {
        return 0L;
    }

    public long getRollingCountFallbackFailure() {
        return 0L;
    }

    public long getRollingCountFallbackMissing() {
        return this.getErrorCount();
    }

    public long getRollingCountFallbackRejection() {
        return 0L;
    }

    public long getRollingCountFallbackSuccess() {
        return 0L;
    }

    public long getRollingCountResponsesFromCache() {
        return 0L;
    }

    public long getRollingCountSemaphoreRejected() {
        return 0L;
    }

    public long getRollingCountShortCircuited() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getMetrics().getNumberOfNotPermittedCalls();
        }
        return 0L;
    }

    public long getRollingCountSuccess() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getMetrics().getNumberOfSuccessfulCalls();
        }
        return 0L;
    }

    public long getRollingCountThreadPoolRejected() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getMetrics().getNumberOfFailedCalls();
        }
        return 0L;
    }

    public long getRollingCountTimeout() {
        return 0L;
    }

    public long getCurrentConcurrentExecutionCount() {
        if (Objects.nonNull(this.bulkhead)) {
            int available = this.bulkhead.getMetrics().getAvailableConcurrentCalls();
            int max = this.bulkhead.getMetrics().getMaxAllowedConcurrentCalls();
            return max - available;
        }
        if (Objects.nonNull(this.threadPoolBulkhead)) {
            int max = this.threadPoolBulkhead.getMetrics().getMaximumThreadPoolSize();
            int available = this.threadPoolBulkhead.getMetrics().getThreadPoolSize();
            return max - available;
        }
        return 0L;
    }

    public long getRollingMaxConcurrentExecutionCount() {
        return 0L;
    }

    public int getLatencyExecute_mean() {
        if (Objects.nonNull(this.serverTimer)) {
            double mean = this.serverTimer.getMetrics().getSnapshot().getMean();
            return (int)TimeUnit.MILLISECONDS.convert((long)mean, TimeUnit.NANOSECONDS);
        }
        return 0;
    }

    public LatencyHistogram getLatencyExecute() {
        if (Objects.nonNull(this.serverTimer)) {
            Snapshot snapshot = this.serverTimer.getMetrics().getSnapshot();
            return new LatencyHistogram((int)TimeUnit.MILLISECONDS.convert(snapshot.getMin(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.getMedian(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.getMedian(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get75thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get95thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get95thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get99thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get999thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert(snapshot.getMax(), TimeUnit.NANOSECONDS));
        }
        return new LatencyHistogram(0, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    @JsonProperty(value="latencyTotal_mean")
    public int getLatencyTotal_mean() {
        if (Objects.nonNull(this.clientTimer)) {
            double mean = this.clientTimer.getMetrics().getSnapshot().getMean();
            return (int)TimeUnit.MILLISECONDS.convert((long)mean, TimeUnit.NANOSECONDS);
        }
        return 0;
    }

    public LatencyHistogram getLatencyTotal() {
        if (Objects.nonNull(this.clientTimer)) {
            Snapshot snapshot = this.clientTimer.getMetrics().getSnapshot();
            return new LatencyHistogram((int)TimeUnit.MILLISECONDS.convert(snapshot.getMin(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.getMedian(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.getMedian(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get75thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get95thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get95thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get99thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert((long)snapshot.get999thPercentile(), TimeUnit.NANOSECONDS), (int)TimeUnit.MILLISECONDS.convert(snapshot.getMax(), TimeUnit.NANOSECONDS));
        }
        return new LatencyHistogram(0, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public int getPropertyValue_circuitBreakerRequestVolumeThreshold() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getCircuitBreakerConfig().getMinimumNumberOfCalls();
        }
        return 0;
    }

    public long getPropertyValue_circuitBreakerSleepWindowInMilliseconds() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return (Long)this.circuitBreaker.getCircuitBreakerConfig().getWaitIntervalFunctionInOpenState().apply((Object)1);
        }
        return 0L;
    }

    public String getPropertyValue_circuitBreakerSlidingWindowType() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getCircuitBreakerConfig().getSlidingWindowType().name();
        }
        return "UNKNOWN";
    }

    public int getPropertyValue_circuitBreakerErrorThresholdPercentage() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return (int)this.circuitBreaker.getCircuitBreakerConfig().getFailureRateThreshold();
        }
        return 0;
    }

    public boolean getPropertyValue_circuitBreakerForceOpen() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getState() == CircuitBreaker.State.FORCED_OPEN;
        }
        return false;
    }

    public boolean getPropertyValue_circuitBreakerForceClosed() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getState() == CircuitBreaker.State.DISABLED;
        }
        return false;
    }

    public HystrixCommandProperties.ExecutionIsolationStrategy getPropertyValue_executionIsolationStrategy() {
        if (Objects.nonNull(this.bulkhead)) {
            return HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE;
        }
        if (Objects.nonNull(this.threadPoolBulkhead)) {
            return HystrixCommandProperties.ExecutionIsolationStrategy.THREAD;
        }
        return HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE;
    }

    public int getPropertyValue_executionIsolationThreadTimeoutInMilliseconds() {
        if (Objects.nonNull(this.timeLimiter)) {
            return (int)(this.timeLimiter.getTimeLimiterConfig().getTimeoutDuration().getSeconds() * 1000L);
        }
        return 0;
    }

    public int getPropertyValue_executionTimeoutInMilliseconds() {
        if (Objects.nonNull(this.timeLimiter)) {
            return (int)(this.timeLimiter.getTimeLimiterConfig().getTimeoutDuration().getSeconds() * 1000L);
        }
        return 0;
    }

    public boolean getPropertyValue_executionIsolationThreadInterruptOnTimeout() {
        return false;
    }

    public String getPropertyValue_executionIsolationThreadPoolKeyOverride() {
        return null;
    }

    public int getPropertyValue_executionIsolationSemaphoreMaxConcurrentRequests() {
        if (Objects.nonNull(this.bulkhead)) {
            return this.bulkhead.getMetrics().getMaxAllowedConcurrentCalls();
        }
        return 0;
    }

    public int getPropertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests() {
        return 0;
    }

    public int getPropertyValue_metricsRollingStatisticalWindowInMilliseconds() {
        if (Objects.nonNull(this.circuitBreaker)) {
            return this.circuitBreaker.getCircuitBreakerConfig().getSlidingWindowSize() * 1000;
        }
        return 0;
    }

    public boolean getPropertyValue_requestCacheEnabled() {
        return false;
    }

    public boolean getPropertyValue_requestLogEnabled() {
        return false;
    }

    public String getThreadPool() {
        if (Objects.nonNull(this.threadPoolBulkhead)) {
            return this.threadPoolBulkhead.getName();
        }
        return null;
    }
}

