/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.resilienthttpclient;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.flipkart.resilience4all.resilience4j.timer.TimerRegistry;
import com.flipkart.resilienthttpclient.BaseResilientAsyncHttpClientDecorator;
import com.flipkart.resilienthttpclient.ResilientDomainDecoratorFactory;
import com.flipkart.resilienthttpclient.ResilientListenableFuture;
import com.flipkart.resilienthttpclient.exceptions.ClientSideException;
import com.flipkart.resilienthttpclient.handlers.AsyncHandlerDecoratorFor5xx;
import com.flipkart.resilienthttpclient.handlers.AsyncHandlerDecoratorForMaxContentLength;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.metrics.BulkheadMetrics;
import io.github.resilience4j.metrics.CircuitBreakerMetrics;
import io.github.resilience4j.metrics.RetryMetrics;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;

public abstract class ResilientDomain
extends BaseResilientAsyncHttpClientDecorator {
    private final ResilientDomainDecoratorFactory decoratorFactory;

    private ResilientDomain(AsyncHttpClient innerAsyncHttpClient, ResilientDomainDecoratorFactory decoratorFactory) {
        super(innerAsyncHttpClient);
        this.decoratorFactory = decoratorFactory;
    }

    public static Builder builder(String domainName) {
        return new Builder(domainName);
    }

    @Override
    public ListenableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return this.executeRequest(requestBuilder.build());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, AsyncHandler<T> handler) {
        return this.executeRequest(requestBuilder.build(), handler);
    }

    @Override
    public ListenableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, AsyncCompletionHandlerBase::new);
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) {
        return this.executeRequest(request, () -> handler);
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request, Supplier<AsyncHandler<T>> handlerSupplier) {
        return new ResilientListenableFuture<T>(this.getInnerAsyncHttpClient(), request, this.getDecorator(), () -> this.decorateAsyncHandler((AsyncHandler)handlerSupplier.get()));
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, Supplier<AsyncHandler<T>> handlerSupplier) {
        return this.executeRequest(requestBuilder.build(), handlerSupplier);
    }

    protected <T> UnaryOperator<Supplier<CompletionStage<T>>> getDecorator() {
        return this.decoratorFactory.create();
    }

    protected abstract <T> AsyncHandler<T> decorateAsyncHandler(AsyncHandler<T> var1);

    public static class Builder {
        private final String domainName;
        private AsyncHttpClient asyncHttpClient;
        private CircuitBreakerConfig circuitBreakerConfig;
        private CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
        private String circuitBreakerName;
        private RetryConfig retryConfig;
        private ScheduledExecutorService retryExecutor;
        private String retryName;
        private RetryRegistry retryRegistry = RetryRegistry.ofDefaults();
        private BulkheadConfig bulkheadConfig;
        private String bulkheadName;
        private BulkheadRegistry bulkheadRegistry = BulkheadRegistry.ofDefaults();
        private MetricRegistry metricRegistry;
        private TimerRegistry timerRegistry;
        private int maxContentLengthInBytes = -1;
        private boolean record5xxAsFailure = true;

        public Builder(String domainName) {
            this.retryName = this.bulkheadName = domainName;
            this.circuitBreakerName = this.bulkheadName;
            this.domainName = this.bulkheadName;
        }

        public Builder asyncHttpClient(AsyncHttpClient httpClient) {
            this.asyncHttpClient = httpClient;
            return this;
        }

        public Builder circuitBreakerConfig(CircuitBreakerConfig config) {
            this.circuitBreakerConfig = config;
            return this;
        }

        public Builder circuitBreakerName(String name) {
            this.circuitBreakerName = name;
            return this;
        }

        public Builder circuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
            this.circuitBreakerRegistry = circuitBreakerRegistry;
            return this;
        }

        public Builder retryConfig(RetryConfig config, ScheduledExecutorService executor) {
            this.retryConfig = config;
            this.retryExecutor = executor;
            return this;
        }

        public Builder retryName(String name) {
            this.retryName = name;
            return this;
        }

        public Builder retryRegistry(RetryRegistry retryRegistry) {
            this.retryRegistry = retryRegistry;
            return this;
        }

        public Builder bulkheadConfig(BulkheadConfig config) {
            this.bulkheadConfig = config;
            return this;
        }

        public Builder bulkheadName(String name) {
            this.bulkheadName = name;
            return this;
        }

        public Builder bulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
            this.bulkheadRegistry = bulkheadRegistry;
            return this;
        }

        public Builder metricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public Builder timerRegistry(TimerRegistry timerRegistry) {
            this.timerRegistry = timerRegistry;
            return this;
        }

        public Builder maxContentLengthInBytes(int maxContentLengthInBytes) {
            this.maxContentLengthInBytes = maxContentLengthInBytes;
            return this;
        }

        public Builder record5xxAsFailure(boolean record5xxAsFailure) {
            this.record5xxAsFailure = record5xxAsFailure;
            return this;
        }

        public AsyncHttpClient build() {
            if (Objects.isNull(this.asyncHttpClient)) {
                throw new IllegalArgumentException("AsyncHttpClient is a mandatory parameter to build.");
            }
            if (Objects.isNull(this.metricRegistry)) {
                throw new IllegalArgumentException("MetricRegistry is a mandatory parameter to build.");
            }
            if (Objects.isNull(this.timerRegistry)) {
                this.timerRegistry = TimerRegistry.ofMetricRegistry((MetricRegistry)this.metricRegistry);
            }
            CircuitBreaker circuitBreaker = null;
            if (Objects.nonNull(this.circuitBreakerConfig)) {
                CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.from((CircuitBreakerConfig)this.circuitBreakerConfig);
                Predicate<Throwable> ignoreExceptionsPredicate = this.circuitBreakerConfig.getIgnoreExceptionPredicate().or(t -> t instanceof ClientSideException);
                builder.ignoreException(ignoreExceptionsPredicate);
                circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(this.circuitBreakerName, builder.build());
                this.metricRegistry.registerAll((MetricSet)CircuitBreakerMetrics.ofCircuitBreaker((CircuitBreaker)circuitBreaker));
            }
            Bulkhead bulkhead = null;
            if (Objects.nonNull(this.bulkheadConfig)) {
                bulkhead = this.bulkheadRegistry.bulkhead(this.bulkheadName, this.bulkheadConfig);
                this.metricRegistry.registerAll((MetricSet)BulkheadMetrics.ofBulkhead((Bulkhead)bulkhead));
            }
            if (Objects.isNull(this.retryConfig)) {
                this.retryConfig = RetryConfig.custom().maxAttempts(1).build();
            }
            RetryConfig.Builder builder = RetryConfig.from((RetryConfig)this.retryConfig);
            Predicate<Throwable> retryPredicate = this.retryConfig.getExceptionPredicate().and(t -> !(t instanceof ClientSideException));
            builder.retryOnException(retryPredicate);
            Retry retry = this.retryRegistry.retry(this.retryName, builder.build());
            this.metricRegistry.registerAll((MetricSet)RetryMetrics.ofRetry((Retry)retry));
            ResilientDomainDecoratorFactory decoratorFactory = ResilientDomainDecoratorFactory.builder().circuitBreaker(circuitBreaker).bulkhead(bulkhead).retry(retry).retryExecutor(this.retryExecutor).domainName(this.domainName).timerRegistry(this.timerRegistry).build();
            final boolean record5xxAsFailure = this.record5xxAsFailure;
            final int maxContentLengthInBytes = this.maxContentLengthInBytes;
            return new ResilientDomain(this.asyncHttpClient, decoratorFactory){

                @Override
                protected <T> AsyncHandler<T> decorateAsyncHandler(AsyncHandler<T> handler) {
                    if (record5xxAsFailure) {
                        handler = new AsyncHandlerDecoratorFor5xx<T>(handler);
                    }
                    if (maxContentLengthInBytes > -1) {
                        handler = new AsyncHandlerDecoratorForMaxContentLength<T>(handler, maxContentLengthInBytes);
                    }
                    return handler;
                }
            };
        }
    }
}

