/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.helper.Injector;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.sets.HandlerSet;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;

public class Song {
    private Tune tune;

    public Song(Tune tune) {
        this.tune = tune;
    }

    public void createType(String name, String fullPackage, TypeModel typeModel, File targetFolder) throws IOException {
        MetaInfo metaInfo = new MetaInfo(name, fullPackage, Helper.getTypeVariables(typeModel.getGenericVariables()));
        RuleSet ruleSet = Injector.processRuleSet(this.tune, metaInfo);
        HandlerSet handlerSet = Injector.processHandlerSet(this.tune, metaInfo, ruleSet);
        Injector.processFieldTypeHandlerSet(this.tune, metaInfo);
        Injector.processParameterTypeHandlerSet(this.tune, metaInfo);
        Injector.processFieldAdditionalHandlers(this.tune, metaInfo);
        Injector.processTypeAdditionalHandlers(this.tune, metaInfo);
        Injector.processFieldModificationHandlers(this.tune, metaInfo);
        TypeSpec.Builder typeBuilder = Helper.getCreator(typeModel.getType(), this.tune.getCreatorSet()).process(handlerSet, typeModel);
        JavaFile javaFile = JavaFile.builder((String)fullPackage, (TypeSpec)typeBuilder.build()).indent("    ").skipJavaLangImports(true).build();
        javaFile.writeTo(targetFolder);
    }
}

