/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.constructors;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public abstract class ConstructorHandler
extends Handler {
    public ConstructorHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        Map<String, FieldModel> fields = typeModel.getFields();
        List<String> constructorFields = this.getConstructorFields(typeModel);
        if (constructorFields.isEmpty()) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        if (this.getModifier() != null) {
            constructor = constructor.addModifiers(new Modifier[]{this.getModifier()});
        }
        for (String field : constructorFields) {
            ParameterSpec.Builder parameterSpec = Helper.getParameterTypeHandler(fields.get(field).getFieldType(), this.tune.getParameterTypeHandlerSet()).process(typeSpec, field, fields.get(field));
            if (!fields.get(field).isPrimitive()) {
                this.tune.getValidationAnnotatorStyles().forEach(style -> {
                    if (((FieldModel)fields.get(field)).isRequired()) {
                        style.processRequiredRuleForConstructor(parameterSpec);
                    } else {
                        style.processNotRequiredRuleForConstructor(parameterSpec);
                    }
                });
            }
            constructor.addParameter(parameterSpec.build());
            constructor.addStatement("this.$L = $L", new Object[]{field, field});
        }
        typeSpec.addMethod(constructor.build());
    }

    protected abstract List<String> getConstructorFields(TypeModel var1);

    protected abstract Modifier getModifier();
}

