/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.FieldType;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.MethodModel;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class AnnotationMethodsHandler
extends Handler {
    public AnnotationMethodsHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        Map<String, MethodModel> methods = typeModel.getMethods();
        if (Helper.isNullOrEmpty(methods)) {
            return;
        }
        for (Map.Entry<String, MethodModel> methodEntry : methods.entrySet()) {
            FieldModel returnsModel = methodEntry.getValue().getReturnType();
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodEntry.getKey()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Helper.processType(returnsModel, this.metaInfo.getGenericVariables()));
            if (methodEntry.getValue().getDefaultValue() != null) {
                builder.defaultValue(returnsModel.getFieldType() == FieldType.STRING ? "$S" : "$L", new Object[]{methodEntry.getValue().getDefaultValue()});
            }
            typeBuilder.addMethod(builder.build());
        }
    }
}

