/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.annotations;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.AnnotationModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ClassAnnotationHandler
extends Handler {
    public ClassAnnotationHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        List<AnnotationModel> classAnnotations = this.consolidateClassAnnotations(this.tune, typeModel);
        for (AnnotationModel model : classAnnotations) {
            ClassName annotationName = Helper.getClassName(model.getClassName());
            AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder((ClassName)annotationName);
            Optional.ofNullable(model.getMembers()).map(Map::entrySet).ifPresent(entries -> entries.forEach(entry -> annotationBuilder.addMember((String)entry.getKey(), (String)entry.getValue(), new Object[0])));
            typeSpec.addAnnotation(annotationBuilder.build());
        }
    }

    private List<AnnotationModel> consolidateClassAnnotations(Tune configuration, TypeModel typeModel) {
        ArrayList<AnnotationModel> classAnnotations = new ArrayList<AnnotationModel>();
        Optional.ofNullable(configuration.getClassLevelAnnotations()).ifPresent(annotations -> annotations.forEach(classAnnotations::add));
        Optional.ofNullable(typeModel.getAnnotations()).ifPresent(annotations -> annotations.forEach(classAnnotations::add));
        return classAnnotations;
    }
}

