/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class ToStringHandler
extends Handler {
    public ToStringHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        if (!this.tune.isToStringNeeded() || this.tune.getObjectMethodsStyle() == null) {
            return;
        }
        Map<String, FieldModel> fieldModels = typeModel.getFields();
        List<String> nonStaticFields = fieldModels.entrySet().stream().filter(entry -> !((FieldModel)entry.getValue()).isExcludeFromToString() && !Arrays.stream(((FieldModel)entry.getValue()).getModifiers()).anyMatch(modifier -> modifier.equals((Object)Modifier.STATIC))).map(Map.Entry::getKey).collect(Collectors.toList());
        MethodSpec.Builder toStringBuilder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class);
        this.tune.getObjectMethodsStyle().processToString(toStringBuilder, nonStaticFields, this.metaInfo);
        typeBuilder.addMethod(toStringBuilder.build());
    }
}

