/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.specs;

import com.flipkart.lyrics.helper.Util;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.CodeBlock;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.ParameterSpec;
import com.flipkart.lyrics.specs.TypeName;
import com.flipkart.lyrics.specs.TypeVariableName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MethodSpec {
    static final String CONSTRUCTOR = "<init>";
    public final String name;
    public final CodeBlock doc;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final List<TypeVariableName> typeVariables;
    public final TypeName returnType;
    public final List<ParameterSpec> parameters;
    public final boolean varargs;
    public final List<TypeName> exceptions;
    public final CodeBlock defaultValue;
    public final CodeBlock code;

    protected MethodSpec(Builder builder) {
        this.name = Util.checkNotNull(builder.name, "name == null", new Object[0]);
        this.doc = builder.doc.build();
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.typeVariables = Util.immutableList(builder.typeVariables);
        this.returnType = builder.returnType;
        this.parameters = Util.immutableList(builder.parameters);
        this.varargs = builder.varargs;
        this.exceptions = Util.immutableList(builder.exceptions);
        this.defaultValue = builder.defaultValue;
        this.code = builder.code.build();
    }

    public static Builder methodBuilder(String name) {
        return new Builder(name);
    }

    public static Builder constructorBuilder() {
        return new Builder(CONSTRUCTOR);
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name);
        builder.doc.add(this.doc);
        builder.annotations.addAll(this.annotations);
        builder.modifiers.addAll(this.modifiers);
        builder.typeVariables.addAll(this.typeVariables);
        builder.returnType = this.returnType;
        builder.parameters.addAll(this.parameters);
        builder.exceptions.addAll(this.exceptions);
        builder.varargs = this.varargs;
        builder.defaultValue = this.defaultValue;
        return builder;
    }

    public boolean isConstructor() {
        return this.name.equals(CONSTRUCTOR);
    }

    public static final class Builder {
        private final String name;
        private final CodeBlock.Builder doc = CodeBlock.builder();
        private final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private final List<ParameterSpec> parameters = new ArrayList<ParameterSpec>();
        private final Set<TypeName> exceptions = new LinkedHashSet<TypeName>();
        private final CodeBlock.Builder code = CodeBlock.builder();
        private List<TypeVariableName> typeVariables = new ArrayList<TypeVariableName>();
        private TypeName returnType;
        private boolean varargs;
        private CodeBlock defaultValue;

        protected Builder(String name) {
            this.name = name;
        }

        public Builder addModifiers(Modifier ... modifiers) {
            this.modifiers.addAll(Arrays.asList(modifiers));
            return this;
        }

        public Builder returns(TypeName typeName) {
            this.returnType = typeName;
            return this;
        }

        public Builder returns(Type type) {
            this.returnType = TypeName.get(type);
            return this;
        }

        public Builder addAnnotation(Class<?> clazz) {
            this.annotations.add(AnnotationSpec.builder(clazz).build());
            return this;
        }

        public Builder addAnnotation(ClassName className) {
            this.annotations.add(AnnotationSpec.builder(className).build());
            return this;
        }

        public Builder addParameter(ParameterSpec parameterSpec) {
            this.parameters.add(parameterSpec);
            return this;
        }

        public Builder addParameter(TypeName typeName, String name, Modifier ... modifiers) {
            this.parameters.add(ParameterSpec.builder(typeName, name, modifiers).build());
            return this;
        }

        public Builder addParameter(Class<?> type, String name, Modifier ... modifiers) {
            this.parameters.add(ParameterSpec.builder(type, name, modifiers).build());
            return this;
        }

        public Builder defaultValue(String format, Object ... args) {
            this.defaultValue = CodeBlock.of(format, args);
            return this;
        }

        public Builder addCode(String format, Object ... args) {
            this.code.add(format, args);
            return this;
        }

        public Builder addComment(String format, Object ... args) {
            this.code.add("// " + format + "\n", args);
            return this;
        }

        public Builder addStatement(String format, Object ... args) {
            this.code.addStatement(format, args);
            return this;
        }

        public Builder beginControlFlow(String format, Object ... args) {
            this.code.beginControlFlow(format, args);
            return this;
        }

        public Builder nextControlFlow(String controlFlow, Object ... args) {
            this.code.nextControlFlow(controlFlow, args);
            return this;
        }

        public Builder endControlFlow() {
            this.code.endControlFlow();
            return this;
        }

        public Builder endControlFlow(String controlFlow, Object ... args) {
            this.code.endControlFlow(controlFlow, args);
            return this;
        }

        public MethodSpec build() {
            return new MethodSpec(this);
        }
    }
}

