/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.helper;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.creator.TypeCreator;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.FieldType;
import com.flipkart.lyrics.model.GenericVariableModel;
import com.flipkart.lyrics.model.Primitive;
import com.flipkart.lyrics.model.Type;
import com.flipkart.lyrics.model.VariableModel;
import com.flipkart.lyrics.processor.constructors.ParameterTypeHandler;
import com.flipkart.lyrics.processor.fields.FieldTypeHandler;
import com.flipkart.lyrics.sets.CreatorSet;
import com.flipkart.lyrics.sets.FieldTypeHandlerSet;
import com.flipkart.lyrics.sets.ParameterTypeHandlerSet;
import com.flipkart.lyrics.specs.ArrayTypeName;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.ParameterizedTypeName;
import com.flipkart.lyrics.specs.TypeName;
import com.flipkart.lyrics.specs.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Helper {
    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static TypeName getClassName(String name, Map<String, TypeVariableName> typeVariableNames) {
        int lastIndex = name.lastIndexOf(".");
        if (lastIndex < 0) {
            return typeVariableNames.get(name);
        }
        return ClassName.get(name.substring(0, lastIndex), name.substring(lastIndex + 1), new String[0]);
    }

    public static ClassName getClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        if (lastIndex < 0) {
            return ClassName.get("", name, new String[0]);
        }
        return ClassName.get(name.substring(0, lastIndex), name.substring(lastIndex + 1), new String[0]);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getGetterSetterName(String name, boolean isSetter, boolean isBoolean, boolean isPrimitive) {
        String capitalizedName = Helper.capitalize(name);
        String prefix = "get";
        if (isBoolean) {
            if (capitalizedName.startsWith("Is") && capitalizedName.length() > 2 && Character.isUpperCase(capitalizedName.charAt(2))) {
                capitalizedName = capitalizedName.substring(2);
            }
            if (isPrimitive) {
                prefix = "is";
            }
        }
        if (isSetter) {
            prefix = "set";
        }
        return prefix + capitalizedName;
    }

    public static TypeName getResolvedTypeName(VariableModel variableModel, Map<String, TypeVariableName> typeVariableNames) {
        TypeName typeName;
        if (variableModel.getTypes().length > 0) {
            ClassName className = Helper.getClassName(variableModel.getType());
            TypeName[] typeNames = new TypeName[variableModel.getTypes().length];
            for (int i = 0; i < variableModel.getTypes().length; ++i) {
                typeNames[i] = Helper.getResolvedTypeName(variableModel.getTypes()[i], typeVariableNames);
            }
            typeName = ParameterizedTypeName.get(className, typeNames);
        } else {
            typeName = Helper.getClassName(variableModel.getType(), typeVariableNames);
        }
        return typeName;
    }

    public static Map<String, TypeVariableName> getTypeVariables(List<GenericVariableModel> genericVariables) {
        HashMap<String, TypeVariableName> typeVariableNames = new HashMap<String, TypeVariableName>();
        for (GenericVariableModel variable : genericVariables) {
            ArrayList<TypeName> resolvedBounds = new ArrayList<TypeName>();
            for (VariableModel variableModel : variable.getBounds()) {
                if (variableModel == null) continue;
                resolvedBounds.add(Helper.getResolvedTypeName(variableModel, typeVariableNames));
            }
            TypeVariableName typeVariableName = TypeVariableName.get(variable.getName());
            if (!resolvedBounds.isEmpty()) {
                typeVariableName = typeVariableName.withBounds(resolvedBounds);
            }
            typeVariableNames.put(variable.getName(), typeVariableName);
        }
        return typeVariableNames;
    }

    public static Modifier[] resolveModifiers(Tune tune, FieldModel fieldModel) {
        if (tune.getDefaultFieldModifier() == null) {
            return fieldModel.getModifiers();
        }
        if (tune.forceDefaultFieldModifiers() || fieldModel.getModifiers().length == 0 && !fieldModel.isPackageVisibility()) {
            return new Modifier[]{tune.getDefaultFieldModifier()};
        }
        return fieldModel.getModifiers();
    }

    public static TypeCreator getCreator(Type type, CreatorSet creatorSet) {
        switch (type) {
            case ANNOTATION: {
                return creatorSet.getAnnotationCreator();
            }
            case CLASS: {
                return creatorSet.getClassCreator();
            }
            case ENUM: {
                return creatorSet.getEnumCreator();
            }
            case ENUM_WITH_FIELDS: {
                return creatorSet.getEnumWithFieldsCreator();
            }
            case INTERFACE: {
                return creatorSet.getInterfaceCreator();
            }
        }
        return creatorSet.getClassCreator();
    }

    public static FieldTypeHandler getFieldTypeHandler(FieldType type, FieldTypeHandlerSet handlerSet) {
        switch (type) {
            case BOOLEAN: {
                return handlerSet.getBooleanTypeHandler();
            }
            case BYTE: {
                return handlerSet.getByteTypeHandler();
            }
            case CHARACTER: {
                return handlerSet.getCharacterTypeHandler();
            }
            case DOUBLE: {
                return handlerSet.getDoubleTypeHandler();
            }
            case FLOAT: {
                return handlerSet.getFloatTypeHandler();
            }
            case INTEGER: {
                return handlerSet.getIntegerTypeHandler();
            }
            case LONG: {
                return handlerSet.getLongTypeHandler();
            }
            case SHORT: {
                return handlerSet.getShortTypeHandler();
            }
            case OBJECT: {
                return handlerSet.getObjectTypeHandler();
            }
            case STRING: {
                return handlerSet.getStringTypeHandler();
            }
            case ENUM: {
                return handlerSet.getEnumTypeHandler();
            }
        }
        return handlerSet.getObjectTypeHandler();
    }

    public static ParameterTypeHandler getParameterTypeHandler(FieldType type, ParameterTypeHandlerSet handlerSet) {
        switch (type) {
            case BOOLEAN: {
                return handlerSet.getBooleanTypeHandler();
            }
            case BYTE: {
                return handlerSet.getByteTypeHandler();
            }
            case CHARACTER: {
                return handlerSet.getCharacterTypeHandler();
            }
            case DOUBLE: {
                return handlerSet.getDoubleTypeHandler();
            }
            case FLOAT: {
                return handlerSet.getFloatTypeHandler();
            }
            case INTEGER: {
                return handlerSet.getIntegerTypeHandler();
            }
            case LONG: {
                return handlerSet.getLongTypeHandler();
            }
            case SHORT: {
                return handlerSet.getShortTypeHandler();
            }
            case OBJECT: {
                return handlerSet.getObjectTypeHandler();
            }
            case STRING: {
                return handlerSet.getStringTypeHandler();
            }
            case ENUM: {
                return handlerSet.getEnumTypeHandler();
            }
        }
        return handlerSet.getObjectTypeHandler();
    }

    public static TypeName processType(FieldModel fieldModel, Map<String, TypeVariableName> typeVariableNames) {
        Primitive primitive;
        if (fieldModel == null) {
            return TypeName.VOID;
        }
        switch (fieldModel.getFieldType()) {
            case STRING: {
                return fieldModel.isArray() ? ArrayTypeName.of(String.class) : TypeName.get(String.class);
            }
            case OBJECT: 
            case ENUM: {
                TypeName typeName = fieldModel.getType().getType() == null ? TypeName.OBJECT : Helper.getResolvedTypeName(fieldModel.getType(), typeVariableNames);
                return fieldModel.isArray() ? ArrayTypeName.of(typeName) : typeName;
            }
            case SHORT: {
                primitive = Primitive.SHORT;
                break;
            }
            case INTEGER: {
                primitive = Primitive.INTEGER;
                break;
            }
            case LONG: {
                primitive = Primitive.LONG;
                break;
            }
            case FLOAT: {
                primitive = Primitive.FLOAT;
                break;
            }
            case DOUBLE: {
                primitive = Primitive.DOUBLE;
                break;
            }
            case BYTE: {
                primitive = Primitive.BYTE;
                break;
            }
            case BOOLEAN: {
                primitive = Primitive.BOOLEAN;
                break;
            }
            case CHARACTER: {
                primitive = Primitive.CHARACTER;
                break;
            }
            default: {
                primitive = Primitive.BYTE;
            }
        }
        TypeName typeName = TypeName.get(fieldModel.isPrimitive() ? primitive.getUnboxed() : primitive.getBoxed());
        return fieldModel.isArray() ? ArrayTypeName.of(typeName) : typeName;
    }

    public static List<String> getRequiredFields(Map<String, FieldModel> fields, boolean excludeInitializedFields) {
        return fields.entrySet().stream().filter(entry -> {
            if (!((FieldModel)entry.getValue()).isRequired()) {
                return false;
            }
            return !excludeInitializedFields || ((FieldModel)entry.getValue()).getInitializeWith() == null;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

