/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.constructors;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.constructors.ConstructorHandler;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomConstructorHandler
extends ConstructorHandler {
    public CustomConstructorHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    protected List<String> getConstructorFields(TypeModel typeModel) {
        List<String> customConstructorFields = typeModel.getCustomConstructorFields();
        if (!this.tune.isCustomConstructorNeeded() || customConstructorFields == null) {
            return new ArrayList<String>();
        }
        Map<String, FieldModel> fields = typeModel.getFields();
        List<String> requiredFields = Helper.getRequiredFields(fields, this.tune.excludeInitializedFieldsFromConstructor());
        customConstructorFields.removeAll(requiredFields);
        if (customConstructorFields.isEmpty()) {
            return new ArrayList<String>();
        }
        requiredFields.addAll(customConstructorFields);
        return requiredFields;
    }

    @Override
    protected Modifier getModifier() {
        return Modifier.PUBLIC;
    }
}

