/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.specs;

import com.flipkart.lyrics.helper.Util;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.CodeBlock;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ParameterSpec {
    public final String name;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final TypeName type;
    public final CodeBlock initializer;
    public final String label;
    public final boolean required;

    public ParameterSpec(Builder builder) {
        this.name = Util.checkNotNull(builder.name, "name == null", new Object[0]);
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.type = Util.checkNotNull(builder.type, "type == null", new Object[0]);
        this.initializer = builder.initializer == null ? CodeBlock.builder().build() : builder.initializer;
        this.label = builder.label;
        this.required = builder.required;
    }

    public static Builder builder(TypeName typeName, String name, Modifier ... modifiers) {
        return new Builder(typeName, name, modifiers);
    }

    public static Builder builder(Class<?> clazz, String name, Modifier ... modifiers) {
        return new Builder(TypeName.get(clazz), name, modifiers);
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public Builder toBuilder() {
        return this.toBuilder(this.type, this.name);
    }

    Builder toBuilder(TypeName type, String name) {
        Builder builder = new Builder(type, name, new Modifier[0]);
        builder.annotations.addAll(this.annotations);
        builder.modifiers.addAll(this.modifiers);
        builder.initializer = this.initializer.formats.isEmpty() ? null : this.initializer;
        builder.label = this.label;
        builder.required = this.required;
        return builder;
    }

    public static class Builder {
        private final TypeName type;
        private final String name;
        private final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private CodeBlock initializer = null;
        private String label;
        private boolean required;

        private Builder(TypeName type, String name, Modifier ... modifiers) {
            this.name = name;
            this.type = type;
            Collections.addAll(this.modifiers, modifiers);
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder addAnnotations(Iterable<AnnotationSpec> annotationSpecs) {
            for (AnnotationSpec annotationSpec : annotationSpecs) {
                this.annotations.add(annotationSpec);
            }
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName annotation) {
            this.annotations.add(AnnotationSpec.builder(annotation).build());
            return this;
        }

        public Builder addAnnotation(Class<?> annotation) {
            return this.addAnnotation(ClassName.get(annotation));
        }

        public Builder addModifiers(Modifier ... modifiers) {
            Collections.addAll(this.modifiers, modifiers);
            return this;
        }

        public Builder addModifiers(Iterable<Modifier> modifiers) {
            for (Modifier modifier : modifiers) {
                this.modifiers.add(modifier);
            }
            return this;
        }

        public Builder initializer(String format, Object ... args) {
            return this.initializer(CodeBlock.of(format, args));
        }

        public Builder initializer(CodeBlock codeBlock) {
            Util.checkState(this.initializer == null, "initializer was already set", new Object[0]);
            this.initializer = Util.checkNotNull(codeBlock, "codeBlock == null", new Object[0]);
            return this;
        }

        public ParameterSpec build() {
            return new ParameterSpec(this);
        }
    }
}

