/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.constructors;

import com.flipkart.lyrics.annotators.validations.ValidationAnnotatorStyle;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.CodeBlock;
import com.flipkart.lyrics.specs.MethodSpec;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.ParameterSpec;
import com.flipkart.lyrics.specs.TypeSpec;
import java.util.List;
import java.util.Map;

public abstract class ConstructorHandler
extends Handler {
    public ConstructorHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        CodeBlock superArgs;
        Map<String, FieldModel> fields = typeModel.getFields();
        List<String> constructorFields = this.getConstructorFields(typeModel);
        if (constructorFields.isEmpty()) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        if (this.getModifier() != null) {
            constructor = constructor.addModifiers(this.getModifier());
        }
        if ((superArgs = this.superArgs()) != null) {
            Object[] args = new Object[superArgs.arguments.size()];
            args = superArgs.arguments.toArray(args);
            constructor.addCode(this.superIdentifier() + "." + String.join((CharSequence)"", superArgs.formats), args);
        }
        for (String field : constructorFields) {
            ParameterSpec.Builder parameterSpec = Helper.getParameterTypeHandler(fields.get(field).getFieldType(), this.tune.getParameterTypeHandlerSet()).process(typeSpec, field, fields.get(field));
            if (!fields.get(field).isPrimitive()) {
                this.tune.getValidationAnnotatorStyles().forEach(style -> Helper.requiredParameterConstructorParadigm.accept((ValidationAnnotatorStyle)style, (FieldModel)fields.get(field), parameterSpec));
            }
            parameterSpec.required(fields.get(field).isRequired());
            constructor.addParameter(parameterSpec.build());
            constructor.addStatement("$N.$L = $L", this.selfReference(), field, field);
        }
        typeSpec.addMethod(constructor.build());
    }

    protected abstract List<String> getConstructorFields(TypeModel var1);

    protected abstract Modifier getModifier();

    protected String selfReference() {
        return "this";
    }

    protected String superIdentifier() {
        return "super";
    }

    protected CodeBlock superArgs() {
        return null;
    }
}

