/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.MethodSpec;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.TypeSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EqualsAndHashCodeHandler
extends Handler {
    public EqualsAndHashCodeHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel) {
        if (!this.tune.areHashCodeAndEqualsNeeded() || this.tune.getObjectMethodsStyle() == null) {
            return;
        }
        Map<String, FieldModel> fieldModels = typeModel.getFields();
        List<String> nonStaticFields = fieldModels.entrySet().stream().filter(entry -> !((FieldModel)entry.getValue()).isExcludeFromEqualsAndHashCode() && !Arrays.stream(((FieldModel)entry.getValue()).getModifiers()).anyMatch(modifier -> modifier.equals((Object)Modifier.STATIC))).map(Map.Entry::getKey).collect(Collectors.toList());
        MethodSpec.Builder equalsBuilder = MethodSpec.methodBuilder("equals").addModifiers(Modifier.PUBLIC).returns(Boolean.TYPE).addAnnotation(Override.class).addParameter(Object.class, "o", new Modifier[0]);
        MethodSpec.Builder hashCodeBuilder = MethodSpec.methodBuilder("hashCode").addModifiers(Modifier.PUBLIC).returns(Integer.TYPE).addAnnotation(Override.class);
        this.tune.getObjectMethodsStyle().processEqualsAndHashCode(equalsBuilder, hashCodeBuilder, nonStaticFields, this.metaInfo, typeModel.isTestSuperEquality());
        typeBuilder.addMethod(equalsBuilder.build());
        typeBuilder.addMethod(hashCodeBuilder.build());
    }
}

