/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.fields;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.InitializerModel;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.processor.fields.FieldTypeHandler;
import com.flipkart.lyrics.specs.ArrayTypeName;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.TypeName;
import com.flipkart.lyrics.specs.TypeSpec;

public class ObjectTypeHandler
extends FieldTypeHandler {
    public ObjectTypeHandler(Tune tune, MetaInfo metaInfo) {
        super(tune, metaInfo);
    }

    @Override
    public FieldSpec.Builder process(TypeSpec.Builder typeSpec, String key, FieldModel fieldModel) {
        TypeName typeName = fieldModel.getType() == null ? TypeName.OBJECT : Helper.getResolvedTypeName(fieldModel.getType(), this.metaInfo.getGenericVariables(), this.tune.getChords());
        typeName = fieldModel.isArray() ? ArrayTypeName.of(typeName) : typeName;
        FieldSpec.Builder builder = FieldSpec.builder(typeName, key, Helper.resolveModifiers(this.tune, fieldModel)).required(fieldModel.isRequired());
        InitializerModel initializeWith = fieldModel.getInitializeWith();
        if (initializeWith != null) {
            if (initializeWith.getValue() != null) {
                ClassName fromType = Helper.getClassName(initializeWith.getFromType());
                builder.initializer("$T.$L", fromType, initializeWith.getValue());
            } else if (initializeWith.getNewInstanceOf() != null) {
                ClassName instanceOf = Helper.getClassName(initializeWith.getNewInstanceOf());
                String initializerString = "new $T" + (initializeWith.isInferGenerics() ? "<>" : "") + "()";
                builder.initializer(initializerString, instanceOf);
            }
        }
        return builder;
    }
}

