/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.specs;

import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.CodeBlock;
import com.flipkart.lyrics.specs.TypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationSpec {
    public final TypeName type;
    public final Map<String, List<CodeBlock>> members = new HashMap<String, List<CodeBlock>>();

    private AnnotationSpec(Builder builder) {
        this.type = builder.type;
        this.members.putAll(builder.members);
    }

    public static Builder builder(Class<?> clazz) {
        return new Builder(ClassName.get(clazz));
    }

    public static Builder builder(ClassName className) {
        return new Builder(className);
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type);
        for (Map.Entry<String, List<CodeBlock>> entry : this.members.entrySet()) {
            builder.members.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return builder;
    }

    public static final class Builder {
        private final Map<String, List<CodeBlock>> members = new HashMap<String, List<CodeBlock>>();
        private TypeName type;

        protected Builder(TypeName typeName) {
            this.type = typeName;
        }

        public Builder addMember(String name, String format, Object ... args) {
            List values = this.members.computeIfAbsent(name, k -> new ArrayList());
            values.add(CodeBlock.of(format, args));
            return this;
        }

        public AnnotationSpec build() {
            return new AnnotationSpec(this);
        }
    }
}

