/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.specs;

import com.flipkart.lyrics.helper.Util;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.TypeName;
import com.flipkart.lyrics.specs.TypeVariableName;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ParameterizedTypeName
extends TypeName {
    public final ClassName rawType;
    public final List<TypeName> typeArguments;
    private final ParameterizedTypeName enclosingType;

    ParameterizedTypeName(ParameterizedTypeName enclosingType, ClassName rawType, List<TypeName> typeArguments) {
        this(enclosingType, rawType, typeArguments, new ArrayList<AnnotationSpec>());
    }

    private ParameterizedTypeName(ParameterizedTypeName enclosingType, ClassName rawType, List<TypeName> typeArguments, List<AnnotationSpec> annotations) {
        super(annotations);
        this.rawType = Util.checkNotNull(rawType, "rawType == null", new Object[0]);
        this.enclosingType = enclosingType;
        this.typeArguments = Util.immutableList(typeArguments);
        Util.checkArgument(!this.typeArguments.isEmpty() || enclosingType != null, "no type arguments: %s", rawType);
        for (TypeName typeArgument : this.typeArguments) {
            Util.checkArgument(!typeArgument.isPrimitive() && typeArgument != VOID, "invalid type parameter: %s", typeArgument);
        }
    }

    public static ParameterizedTypeName get(ClassName rawType, TypeName ... typeArguments) {
        return new ParameterizedTypeName(null, rawType, Arrays.asList(typeArguments));
    }

    public static ParameterizedTypeName get(Class<?> rawType, Type ... typeArguments) {
        return new ParameterizedTypeName(null, ClassName.get(rawType), ParameterizedTypeName.list(typeArguments));
    }

    public static ParameterizedTypeName get(ParameterizedType type) {
        return ParameterizedTypeName.get(type, new LinkedHashMap<Type, TypeVariableName>());
    }

    static ParameterizedTypeName get(ParameterizedType type, Map<Type, TypeVariableName> map) {
        ClassName rawType = ClassName.get((Class)type.getRawType());
        ParameterizedType ownerType = type.getOwnerType() instanceof ParameterizedType && !Modifier.isStatic(((Class)type.getRawType()).getModifiers()) ? (ParameterizedType)type.getOwnerType() : null;
        List<TypeName> typeArguments = TypeName.list(type.getActualTypeArguments(), map);
        return ownerType != null ? ParameterizedTypeName.get(ownerType, map).nestedClass(rawType.simpleName(), typeArguments) : new ParameterizedTypeName(null, rawType, typeArguments);
    }

    @Override
    public ParameterizedTypeName annotated(List<AnnotationSpec> annotations) {
        return new ParameterizedTypeName(this.enclosingType, this.rawType, this.typeArguments, this.concatAnnotations(annotations));
    }

    @Override
    public TypeName withoutAnnotations() {
        return new ParameterizedTypeName(this.enclosingType, this.rawType, this.typeArguments, new ArrayList<AnnotationSpec>());
    }

    public ParameterizedTypeName nestedClass(String name) {
        Util.checkNotNull(name, "name == null", new Object[0]);
        return new ParameterizedTypeName(this, this.rawType.nestedClass(name), new ArrayList<TypeName>(), new ArrayList<AnnotationSpec>());
    }

    public ParameterizedTypeName nestedClass(String name, List<TypeName> typeArguments) {
        Util.checkNotNull(name, "name == null", new Object[0]);
        return new ParameterizedTypeName(this, this.rawType.nestedClass(name), typeArguments, new ArrayList<AnnotationSpec>());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedTypeName)) {
            return false;
        }
        ParameterizedTypeName that = (ParameterizedTypeName)o;
        return this.rawType.equals(that.rawType) && this.typeArguments.equals(that.typeArguments) && (this.enclosingType == null || this.enclosingType.equals(that.enclosingType));
    }

    public final int hashCode() {
        int hashCode = this.rawType.hashCode();
        hashCode += 31 * this.typeArguments.hashCode();
        return hashCode += 31 * this.enclosingType.hashCode();
    }
}

