/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.specs;

import com.flipkart.lyrics.helper.Util;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.CodeBlock;
import com.flipkart.lyrics.specs.FieldSpec;
import com.flipkart.lyrics.specs.Kind;
import com.flipkart.lyrics.specs.MethodSpec;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.TypeName;
import com.flipkart.lyrics.specs.TypeVariableName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeSpec {
    public final Kind kind;
    public final String name;
    public final String anonymousClassFormat;
    public final Object[] anonymousClassArgs;
    public final CodeBlock javadoc;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final List<TypeVariableName> typeVariables;
    public final TypeName superclass;
    public final List<TypeName> superinterfaces;
    public final Map<String, TypeSpec> enumConstants;
    public final List<FieldSpec> fieldSpecs;
    public final CodeBlock staticBlock;
    public final CodeBlock initializerBlock;
    public final List<MethodSpec> methodSpecs;
    public final List<TypeSpec> typeSpecs;

    public TypeSpec(Builder builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.anonymousClassFormat = builder.anonymousClassFormat;
        this.anonymousClassArgs = builder.anonymousClassArgs;
        this.javadoc = builder.doc.build();
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.typeVariables = Util.immutableList(builder.typeVariables);
        this.superclass = builder.superclass;
        this.superinterfaces = Util.immutableList(builder.superinterfaces);
        this.enumConstants = Util.immutableMap(builder.enumConstants);
        this.fieldSpecs = Util.immutableList(builder.fieldSpecs);
        this.staticBlock = builder.staticBlock.build();
        this.initializerBlock = builder.initializerBlock.build();
        this.methodSpecs = Util.immutableList(builder.methodSpecs);
        this.typeSpecs = Util.immutableList(builder.typeSpecs);
    }

    public static Builder classBuilder(String name) {
        return new Builder(Kind.CLASS, name);
    }

    public static Builder annotationBuilder(String name) {
        return new Builder(Kind.ANNOTATION, name);
    }

    public static Builder interfaceBuilder(String name) {
        return new Builder(Kind.INTERFACE, name);
    }

    public static Builder enumBuilder(String name) {
        return new Builder(Kind.ENUM, name);
    }

    public static Builder anonymousClassBuilder(String typeArgumentsFormat, Object ... args) {
        return new Builder(Kind.ANONYMOUS, typeArgumentsFormat, args);
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.kind, this.name);
        builder.doc.add(this.javadoc);
        builder.annotations.addAll(this.annotations);
        builder.modifiers.addAll(this.modifiers);
        builder.typeVariables.addAll(this.typeVariables);
        builder.superclass = this.superclass;
        builder.superinterfaces.addAll(this.superinterfaces);
        builder.enumConstants.putAll(this.enumConstants);
        builder.fieldSpecs.addAll(this.fieldSpecs);
        builder.methodSpecs.addAll(this.methodSpecs);
        builder.typeSpecs.addAll(this.typeSpecs);
        builder.initializerBlock.add(this.initializerBlock);
        builder.staticBlock.add(this.staticBlock);
        return builder;
    }

    public static class Builder {
        private final Kind kind;
        private final String name;
        private final String anonymousClassFormat;
        private final Object[] anonymousClassArgs;
        private final CodeBlock.Builder doc = CodeBlock.builder();
        private final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        private final List<Modifier> modifiers = new ArrayList<Modifier>();
        private final List<TypeVariableName> typeVariables = new ArrayList<TypeVariableName>();
        private final List<TypeName> superinterfaces = new ArrayList<TypeName>();
        private final Map<String, TypeSpec> enumConstants = new LinkedHashMap<String, TypeSpec>();
        private final List<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        private final CodeBlock.Builder staticBlock = CodeBlock.builder();
        private final CodeBlock.Builder initializerBlock = CodeBlock.builder();
        private final List<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        private final List<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        private TypeName superclass = ClassName.OBJECT;

        public Builder(Kind kind, String name) {
            this.kind = kind;
            this.name = name;
            this.anonymousClassFormat = null;
            this.anonymousClassArgs = null;
        }

        private Builder(Kind kind, String typeArgumentsFormat, Object ... args) {
            this.kind = kind;
            this.name = null;
            this.anonymousClassFormat = typeArgumentsFormat;
            this.anonymousClassArgs = args;
        }

        public Builder addDoc(String format, Object ... args) {
            this.doc.add(format, args);
            return this;
        }

        public Builder addDoc(CodeBlock block) {
            this.doc.add(block);
            return this;
        }

        public Builder addAnnotations(Iterable<AnnotationSpec> annotationSpecs) {
            for (AnnotationSpec annotationSpec : annotationSpecs) {
                this.annotations.add(annotationSpec);
            }
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName annotation) {
            return this.addAnnotation(AnnotationSpec.builder(annotation).build());
        }

        public Builder addAnnotation(Class<?> annotation) {
            return this.addAnnotation(ClassName.get(annotation));
        }

        public Builder addModifiers(Modifier ... modifiers) {
            Collections.addAll(this.modifiers, modifiers);
            return this;
        }

        public Builder addTypeVariables(Iterable<TypeVariableName> typeVariables) {
            for (TypeVariableName typeVariable : typeVariables) {
                this.typeVariables.add(typeVariable);
            }
            return this;
        }

        public Builder addTypeVariable(TypeVariableName typeVariable) {
            this.typeVariables.add(typeVariable);
            return this;
        }

        public Builder superclass(TypeName superclass) {
            this.superclass = superclass;
            return this;
        }

        public Builder superclass(Type superclass) {
            return this.superclass(TypeName.get(superclass));
        }

        public Builder addSuperinterfaces(Iterable<? extends TypeName> superinterfaces) {
            for (TypeName typeName : superinterfaces) {
                this.addSuperinterface(typeName);
            }
            return this;
        }

        public Builder addSuperinterface(TypeName superinterface) {
            this.superinterfaces.add(superinterface);
            return this;
        }

        public Builder addSuperinterface(Type superinterface) {
            return this.addSuperinterface(TypeName.get(superinterface));
        }

        public Builder addEnumConstant(String name) {
            return this.addEnumConstant(name, TypeSpec.anonymousClassBuilder("", new Object[0]).build());
        }

        public Builder addEnumConstant(String name, TypeSpec typeSpec) {
            this.enumConstants.put(name, typeSpec);
            return this;
        }

        public Builder addFields(Iterable<FieldSpec> fieldSpecs) {
            for (FieldSpec fieldSpec : fieldSpecs) {
                this.addField(fieldSpec);
            }
            return this;
        }

        public Builder addField(FieldSpec fieldSpec) {
            this.fieldSpecs.add(fieldSpec);
            return this;
        }

        public Builder addField(TypeName type, String name, Modifier ... modifiers) {
            return this.addField(FieldSpec.builder(type, name, modifiers).build());
        }

        public Builder addField(Type type, String name, Modifier ... modifiers) {
            return this.addField(TypeName.get(type), name, modifiers);
        }

        public Builder addStaticBlock(CodeBlock block) {
            this.staticBlock.beginControlFlow("static", new Object[0]).add(block).endControlFlow();
            return this;
        }

        public Builder addInitializerBlock(CodeBlock block) {
            this.initializerBlock.add("{\n", new Object[0]).indent().add(block).unindent().add("}\n", new Object[0]);
            return this;
        }

        public Builder addMethods(Iterable<MethodSpec> methodSpecs) {
            for (MethodSpec methodSpec : methodSpecs) {
                this.addMethod(methodSpec);
            }
            return this;
        }

        public Builder addMethod(MethodSpec methodSpec) {
            this.methodSpecs.add(methodSpec);
            return this;
        }

        public Builder addTypes(Iterable<TypeSpec> typeSpecs) {
            for (TypeSpec typeSpec : typeSpecs) {
                this.addType(typeSpec);
            }
            return this;
        }

        public Builder addType(TypeSpec typeSpec) {
            this.typeSpecs.add(typeSpec);
            return this;
        }

        public TypeSpec build() {
            return new TypeSpec(this);
        }
    }
}

