/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.helper;

import com.flipkart.lyrics.specs.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Util {
    public static final Modifier DEFAULT;

    public static void checkArgument(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    public static String join(String separator, List<String> parts) {
        if (parts.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            result.append(separator).append(parts.get(i));
        }
        return result.toString();
    }

    public static <T> T checkNotNull(T reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(String.format(format, args));
        }
        return reference;
    }

    public static <T> List<T> immutableList(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public static void checkState(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(format, args));
        }
    }

    public static <T> Set<T> immutableSet(Collection<T> set) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    static {
        Modifier def = null;
        try {
            def = Modifier.valueOf("DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DEFAULT = def;
    }
}

