/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.instances;

import com.flipkart.lyrics.annotators.validations.ValidationAnnotatorStyle;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.FieldType;
import com.flipkart.lyrics.model.MetaInfo;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.Handler;
import com.flipkart.lyrics.sets.RuleSet;
import com.flipkart.lyrics.specs.ClassName;
import com.flipkart.lyrics.specs.MethodSpec;
import com.flipkart.lyrics.specs.Modifier;
import com.flipkart.lyrics.specs.ParameterSpec;
import com.flipkart.lyrics.specs.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BuilderPatternHandler
extends Handler {
    public BuilderPatternHandler(Tune tune, MetaInfo metaInfo, RuleSet ruleSet) {
        super(tune, metaInfo, ruleSet);
    }

    @Override
    public void process(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        if (!typeModel.isCreateBuilder() || Arrays.stream(typeModel.getModifiers()).anyMatch(m -> m == Modifier.ABSTRACT)) {
            return;
        }
        TypeSpec.Builder builderBuilder = TypeSpec.classBuilder("Builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        this.processBuilderClass(builderBuilder, typeModel);
        this.createBuilderMethod(typeSpec, typeModel);
        typeSpec.addType(builderBuilder.build());
    }

    private void processBuilderClass(TypeSpec.Builder builderBuilder, TypeModel typeModel) {
        this.metaInfo.setOverrideAccessorGeneration(true);
        this.tune.getHandlerSet().getFieldsHandler().process(builderBuilder, typeModel);
        this.tune.getHandlerSet().getRequiredFieldsConstructorHandler().process(builderBuilder, typeModel);
        this.metaInfo.setOverrideAccessorGeneration(false);
        this.createBuilderAccessors(builderBuilder, typeModel);
        this.createBuildMethod(builderBuilder, typeModel);
    }

    private void createBuilderAccessors(TypeSpec.Builder builderBuilder, TypeModel typeModel) {
        Map<String, FieldModel> fields = typeModel.getFields();
        List<String> requiredFields = Helper.getRequiredFields(fields, this.tune.excludeInitializedFieldsFromConstructor());
        ArrayList<String> notRequiredFields = new ArrayList<String>(fields.keySet());
        notRequiredFields.removeAll(requiredFields);
        ClassName builderClass = ClassName.get(this.metaInfo.getFullPackage(), this.metaInfo.getClassName(), "Builder");
        for (String field : notRequiredFields) {
            MethodSpec.Builder builder = MethodSpec.methodBuilder(field);
            builder.returns(builderClass);
            FieldModel fieldModel = fields.get(field);
            ParameterSpec.Builder parameterSpec = Helper.getParameterTypeHandler(fieldModel.getFieldType(), this.tune.getParameterTypeHandlerSet()).process(builderBuilder, field, fieldModel);
            if (!fieldModel.isPrimitive()) {
                this.tune.getValidationAnnotatorStyles().forEach(style -> Helper.requiredParameterConstructorParadigm.accept((ValidationAnnotatorStyle)style, fieldModel, parameterSpec));
            }
            builder.addParameter(parameterSpec.build());
            builder.addStatement("this.$L = $L", field, field);
            builder.addStatement("return this", new Object[0]);
            builderBuilder.addMethod(builder.build());
        }
    }

    private void createBuildMethod(TypeSpec.Builder builderBuilder, TypeModel typeModel) {
        Map<String, FieldModel> fields = typeModel.getFields();
        List<String> requiredFields = Helper.getRequiredFields(fields, this.tune.excludeInitializedFieldsFromConstructor());
        if (!this.tune.isRequiredFieldConstructorNeeded()) {
            requiredFields = new ArrayList<String>();
        }
        ArrayList<String> notRequiredFields = new ArrayList<String>(fields.keySet());
        notRequiredFields.removeAll(requiredFields);
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<Object> placeholderValues = new ArrayList<Object>();
        for (String requiredField : requiredFields) {
            placeholders.add("$L");
            placeholderValues.add(requiredField);
        }
        ClassName builtClass = ClassName.get(this.metaInfo.getFullPackage(), this.metaInfo.getClassName(), new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder("build");
        builder.addModifiers(Modifier.PUBLIC);
        builder.returns(builtClass);
        placeholderValues.add(0, builtClass);
        placeholderValues.add(0, "returning");
        placeholderValues.add(0, builtClass);
        builder.addStatement("$T $L = new $T(" + StringUtils.join(placeholders, (String)", ") + ")", placeholderValues.toArray());
        Iterator iterator = notRequiredFields.iterator();
        while (iterator.hasNext()) {
            String field;
            FieldModel fieldModel = fields.get(field = (String)iterator.next());
            String setterName = Helper.getGetterSetterName(field, true, fieldModel.getFieldType() == FieldType.BOOLEAN, fieldModel.isPrimitive());
            builder.addStatement("$L.$L($L)", "returning", setterName, field);
        }
        builder.addStatement("return returning", new Object[0]);
        builderBuilder.addMethod(builder.build());
    }

    private void createBuilderMethod(TypeSpec.Builder typeSpec, TypeModel typeModel) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("builder");
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.returns(ClassName.get(this.metaInfo.getFullPackage(), this.metaInfo.getClassName(), "Builder"));
        Map<String, FieldModel> fields = typeModel.getFields();
        List<String> requiredFields = Helper.getRequiredFields(fields, this.tune.excludeInitializedFieldsFromConstructor());
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<Object> placeholderValues = new ArrayList<Object>();
        for (String field : requiredFields) {
            ParameterSpec.Builder parameterSpec = Helper.getParameterTypeHandler(fields.get(field).getFieldType(), this.tune.getParameterTypeHandlerSet()).process(null, field, fields.get(field));
            if (!fields.get(field).isPrimitive()) {
                this.tune.getValidationAnnotatorStyles().forEach(style -> Helper.requiredParameterConstructorParadigm.accept((ValidationAnnotatorStyle)style, (FieldModel)fields.get(field), parameterSpec));
            }
            builder.addParameter(parameterSpec.build());
            placeholders.add("$L");
            placeholderValues.add(field);
        }
        placeholderValues.add(0, ClassName.get(this.metaInfo.getFullPackage(), this.metaInfo.getClassName(), new String[0]));
        builder.addStatement("return new $T.Builder(" + StringUtils.join(placeholders, (String)", ") + ")", placeholderValues.toArray());
        typeSpec.addMethod(builder.build());
    }
}

