/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.specs;

import java.util.ArrayList;
import java.util.List;

public final class CodeBlock {
    public final List<String> formats = new ArrayList<String>();
    public final List<Object> arguments = new ArrayList<Object>();

    private CodeBlock(Builder builder) {
        this.formats.addAll(builder.formats);
        for (Object arg : builder.arguments) {
            this.arguments.add(arg);
        }
    }

    public static CodeBlock of(String format, Object ... args) {
        return new Builder().add(format, args).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        public List<String> formats = new ArrayList<String>();
        public List<Object> arguments = new ArrayList<Object>();

        private Builder() {
        }

        public Builder add(String format, Object ... args) {
            this.formats.add(format);
            for (Object object : args) {
                this.arguments.add(object);
            }
            return this;
        }

        public Builder beginControlFlow(String controlFlow, Object ... args) {
            this.add(controlFlow + " {\n", args);
            this.indent();
            return this;
        }

        public Builder nextControlFlow(String controlFlow, Object ... args) {
            this.unindent();
            this.add("} " + controlFlow + " {\n", args);
            this.indent();
            return this;
        }

        public Builder endControlFlow() {
            this.unindent();
            this.add("}\n", new Object[0]);
            return this;
        }

        public Builder endControlFlow(String controlFlow, Object ... args) {
            this.unindent();
            this.add("} " + controlFlow + ";\n", args);
            return this;
        }

        public Builder addStatement(String format, Object ... args) {
            this.add("$[", new Object[0]);
            this.add(format, args);
            this.add(";\n$]", new Object[0]);
            return this;
        }

        public Builder addStatement(CodeBlock codeBlock) {
            return this.addStatement("$L", codeBlock);
        }

        public Builder add(CodeBlock codeBlock) {
            this.formats.addAll(codeBlock.formats);
            for (Object arg : codeBlock.arguments) {
                this.arguments.add(arg);
            }
            return this;
        }

        public Builder indent() {
            this.formats.add("$>");
            return this;
        }

        public Builder unindent() {
            this.formats.add("$<");
            return this;
        }

        public CodeBlock build() {
            return new CodeBlock(this);
        }
    }
}

