/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.creator;

import com.flipkart.lyrics.creator.TypeCreator;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.sets.HandlerSet;
import com.flipkart.lyrics.specs.AnnotationSpec;
import com.flipkart.lyrics.specs.TypeSpec;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class AnnotationCreator
extends TypeCreator {
    @Override
    public TypeSpec.Builder process(HandlerSet handlerSet, TypeModel typeModel) {
        TypeSpec.Builder typeBuilder = TypeSpec.annotationBuilder(handlerSet.getMetaInfo().getClassName());
        handlerSet.getModifiersHandler().process(typeBuilder, typeModel);
        handlerSet.getAnnotationMethodsHandler().process(typeBuilder, typeModel);
        if (typeModel.getRetention() != null) {
            typeBuilder.addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, typeModel.getRetention()}).build());
        }
        if (typeModel.getElementTypes().length != 0) {
            AnnotationSpec.Builder builder = AnnotationSpec.builder(Target.class);
            for (ElementType elementType : typeModel.getElementTypes()) {
                builder.addMember("value", "$T.$L", new Object[]{ElementType.class, elementType});
            }
            typeBuilder.addAnnotation(builder.build());
        }
        handlerSet.getRuleSet().getGlobalDeprecatedRule().process(typeBuilder, typeModel);
        this.handleAdditionalProperties(handlerSet.getTune(), typeBuilder, typeModel);
        return typeBuilder;
    }
}

