/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.creator;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.creator.TypeCreator;
import com.flipkart.lyrics.model.TypeModel;
import com.flipkart.lyrics.processor.methods.AnnotationMethodsHandler;
import com.flipkart.lyrics.processor.modifiers.ModifiersHandler;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class AnnotationCreator
implements TypeCreator {
    @Override
    public TypeSpec.Builder process(String name, String fullPackage, TypeModel typeModel, Tune configuration) {
        TypeSpec.Builder typeBuilder = TypeSpec.annotationBuilder((String)name);
        new ModifiersHandler().process(typeBuilder, typeModel, configuration);
        new AnnotationMethodsHandler().process(typeBuilder, typeModel, configuration);
        if (typeModel.getRetention() != null) {
            typeBuilder.addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, typeModel.getRetention()}).build());
        }
        if (typeModel.getElementTypes().length != 0) {
            AnnotationSpec.Builder builder = AnnotationSpec.builder(Target.class);
            for (ElementType elementType : typeModel.getElementTypes()) {
                builder.addMember("value", "$T.$L", new Object[]{ElementType.class, elementType});
            }
            typeBuilder.addAnnotation(builder.build());
        }
        return typeBuilder;
    }
}

