/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.rules;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.model.FieldModel;
import com.flipkart.lyrics.model.InclusionType;
import com.flipkart.lyrics.rules.FieldAnnotationRule;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;

public class InclusionRule
implements FieldAnnotationRule {
    @Override
    public void process(FieldSpec.Builder fieldSpec, FieldModel fieldModel, Tune configuration) {
        if (fieldModel.getInclusion() == null) {
            return;
        }
        InclusionType inclusion = fieldModel.getInclusion();
        if (configuration.areJacksonStyleAnnotationsNeeded()) {
            AnnotationSpec annotationSpec = AnnotationSpec.builder(JsonSerialize.class).addMember("include", "JsonSerialize.Inclusion.$L", new Object[]{inclusion}).build();
            fieldSpec.addAnnotation(annotationSpec);
        }
        if (configuration.areGsonStyleAnnotationsNeeded()) {
            // empty if block
        }
    }
}

