/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lyrics.processor.methods;

import com.flipkart.lyrics.config.Tune;
import com.flipkart.lyrics.helper.Helper;
import com.flipkart.lyrics.model.MethodModel;
import com.flipkart.lyrics.model.MethodType;
import com.flipkart.lyrics.model.TypeModel;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class AnnotationMethodsHandler {
    public void process(TypeSpec.Builder typeBuilder, TypeModel typeModel, Tune configuration) {
        Map<String, MethodModel> methods = typeModel.getMethods();
        if (Helper.isNullOrEmpty(methods)) {
            return;
        }
        for (Map.Entry<String, MethodModel> method : methods.entrySet()) {
            MethodSpec.Builder methodBuilder = method.getValue().getMethodType().getMethodHandler().process(typeBuilder, method.getKey(), method.getValue()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            if (method.getValue().getDefaultValue() != null) {
                methodBuilder.defaultValue(method.getValue().getMethodType() == MethodType.STRING ? "$S" : "$L", new Object[]{method.getValue().getDefaultValue()});
            }
            typeBuilder.addMethod(methodBuilder.build());
        }
    }
}

